/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class Language {
    private final String code;
    private static final Map<String, String> CODE_NAME_MAP = new HashMap<String, String>();

    public Language(String code) {
        if (!CODE_NAME_MAP.containsKey(code)) {
            throw new IllegalArgumentException("Unknown language code: " + code);
        }
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static Map<String, String> getCodeMap() {
        return Collections.unmodifiableMap(CODE_NAME_MAP);
    }

    static {
        for (String code : Locale.getISOLanguages()) {
            Locale locale = new Locale(code);
            CODE_NAME_MAP.put(code, locale.getDisplayLanguage(locale));
        }
    }
}

