/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model;

import dk.dma.enav.model.ship.MmsiId;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public abstract class MaritimeId
implements Serializable {
    private static final long serialVersionUID = 1L;
    final String scheme;

    protected MaritimeId(String scheme) {
        this.scheme = Objects.requireNonNull(scheme);
    }

    public static MaritimeId create(String id) {
        URI uri;
        Objects.requireNonNull(id, "id is null");
        try {
            uri = new URI(id);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        String scheme = uri.getScheme();
        if (scheme == null) {
            throw new IllegalArgumentException("Illegal id, must start with 'some_scheme://', was " + id);
        }
        if (uri.getScheme().equals("mmsi")) {
            int mmsi = Integer.parseInt(uri.getHost());
            return new MmsiId(mmsi);
        }
        throw new IllegalArgumentException("Unknown schenme " + uri.getScheme());
    }
}

