/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.geometry;

import dk.dma.enav.model.geometry.CoordinateSystem;
import dk.dma.enav.model.geometry.Element;
import java.util.Objects;
import java.util.function.Predicate;

public abstract class Area
implements Element {
    private static final long serialVersionUID = 1L;
    final CoordinateSystem cs;

    public Area(CoordinateSystem cs) {
        this.cs = Objects.requireNonNull(cs);
    }

    public final Predicate<Element> contains() {
        return new Predicate<Element>(){

            @Override
            public boolean test(Element element) {
                return Area.this.contains(element);
            }
        };
    }

    public final Predicate<Element> intersects() {
        return new Predicate<Element>(){

            @Override
            public boolean test(Element element) {
                return Area.this.intersects(element);
            }
        };
    }

    public boolean contains(Element element) {
        throw new UnsupportedOperationException();
    }

    public boolean intersects(Element element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final double distanceTo(Element other, CoordinateSystem system) {
        return Objects.requireNonNull(system) == CoordinateSystem.CARTESIAN ? this.rhumbLineDistanceTo(other) : this.geodesicDistanceTo(other);
    }

    @Override
    public double geodesicDistanceTo(Element other) {
        throw new UnsupportedOperationException();
    }

    public final CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    @Override
    public double rhumbLineDistanceTo(Element other) {
        throw new UnsupportedOperationException();
    }
}

