/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.geometry;

import dk.dma.enav.model.geometry.CoordinateSystem;
import dk.dma.enav.model.geometry.Element;
import dk.dma.enav.model.geometry.Polygon;
import dk.dma.enav.model.geometry.Position;
import java.util.concurrent.ThreadLocalRandom;

public final class BoundingBox
extends Polygon {
    private static final long serialVersionUID = 1L;
    private final double maxLatitude;
    private final double maxLongitude;
    private final double minLatitude;
    private final double minLongitude;

    private BoundingBox(double minLatitude, double maxLatitude, double minLongitude, double maxLongitude, CoordinateSystem cs) {
        super(cs);
        this.minLatitude = minLatitude;
        this.maxLatitude = maxLatitude;
        this.minLongitude = minLongitude;
        this.maxLongitude = maxLongitude;
    }

    public boolean contains(Position point) {
        return point.getLatitude() >= this.minLatitude && point.getLongitude() >= this.minLongitude && point.getLatitude() <= this.maxLatitude && point.getLongitude() <= this.maxLongitude;
    }

    @Override
    public boolean contains(Element element) {
        if (element instanceof Position) {
            return this.contains((Position)element);
        }
        return super.contains(element);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BoundingBox) {
            BoundingBox that = (BoundingBox)obj;
            return this.minLatitude == that.minLatitude && this.minLongitude == that.minLongitude && this.maxLatitude == that.maxLatitude && this.maxLongitude == that.maxLongitude;
        }
        return false;
    }

    public Position getRandom() {
        ThreadLocalRandom r = ThreadLocalRandom.current();
        return Position.create(r.nextDouble(this.minLatitude, this.maxLatitude), r.nextDouble(this.minLongitude, this.maxLongitude));
    }

    public float getArea() {
        Position a = new Position(this.maxLatitude, this.minLongitude);
        Position b = new Position(this.maxLatitude, this.maxLongitude);
        Position c = new Position(this.minLatitude, this.minLongitude);
        float ab = (float)a.rhumbLineDistanceTo(b);
        float ac = (float)a.rhumbLineDistanceTo(c);
        return ab * ac;
    }

    public Position getCenterPoint() {
        return Position.create((this.minLatitude + this.maxLatitude) / 2.0, (this.minLongitude + this.maxLongitude) / 2.0);
    }

    public double getLatitudeSize() {
        return this.maxLatitude - this.minLatitude;
    }

    public double getLongitudeSize() {
        return this.maxLongitude - this.minLongitude;
    }

    public Position getLowerRight() {
        return Position.create(this.minLatitude, this.maxLongitude);
    }

    public double getMaxLat() {
        return this.maxLatitude;
    }

    public double getMaxLon() {
        return this.maxLongitude;
    }

    public double getMinLat() {
        return this.minLatitude;
    }

    public double getMinLon() {
        return this.minLongitude;
    }

    public Position getUpperLeft() {
        return Position.create(this.maxLatitude, this.minLongitude);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + BoundingBox.hashCode(this.minLatitude);
        result = 37 * result + BoundingBox.hashCode(this.maxLatitude);
        result = 37 * result + BoundingBox.hashCode(this.minLongitude);
        result = 37 * result + BoundingBox.hashCode(this.maxLongitude);
        return result;
    }

    public BoundingBox include(BoundingBox other) {
        double minLon = this.minLongitude;
        double maxLon = this.maxLongitude;
        double minLat = this.minLatitude;
        double maxLat = this.maxLatitude;
        boolean changed = false;
        if (other.minLongitude < minLon) {
            minLon = other.minLongitude;
            changed = true;
        }
        if (other.maxLongitude > maxLon) {
            maxLon = other.maxLongitude;
            changed = true;
        }
        if (other.minLatitude < minLat) {
            minLat = other.minLatitude;
            changed = true;
        }
        if (other.maxLatitude > maxLat) {
            maxLat = other.maxLatitude;
            changed = true;
        }
        return changed ? new BoundingBox(minLat, maxLat, minLon, maxLon, this.cs) : this;
    }

    public BoundingBox include(Position position) {
        return this.include(BoundingBox.create(position, position, CoordinateSystem.CARTESIAN));
    }

    public boolean intersects(BoundingBox other) {
        return !(other.minLongitude > this.maxLongitude || other.maxLongitude < this.minLongitude || other.minLatitude > this.maxLatitude || other.maxLatitude < this.minLatitude);
    }

    public String toString() {
        return this.getUpperLeft() + " -> " + this.getLowerRight();
    }

    static BoundingBox create(double y1, double y2, double x1, double x2, CoordinateSystem cs) {
        return new BoundingBox(Math.min(y1, y2), Math.max(y1, y2), Math.min(x1, x2), Math.max(x1, x2), cs);
    }

    public static BoundingBox create(Position location, Position other, CoordinateSystem cs) {
        return BoundingBox.create(location.getLatitude(), other.getLatitude(), location.getLongitude(), other.getLongitude(), cs);
    }

    private static int hashCode(double x) {
        long f = Double.doubleToLongBits(x);
        return (int)(f ^ f >>> 32);
    }
}

