/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.geometry;

import dk.dma.enav.model.geometry.Area;
import dk.dma.enav.model.geometry.CoordinateSystem;
import dk.dma.enav.model.geometry.Element;
import dk.dma.enav.model.geometry.Position;
import java.util.Objects;

public class Circle
extends Area {
    private static final long serialVersionUID = 1L;
    private final Position center;
    private final double radius;

    public Circle(double latitude, double longitude, double radius, CoordinateSystem cs) {
        this(Position.create(latitude, longitude), radius, cs);
    }

    public Circle(Position center, double radius, CoordinateSystem cs) {
        super(cs);
        this.center = Objects.requireNonNull(center, "center is null");
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be positive, was " + radius);
        }
        this.radius = radius;
    }

    @Override
    public boolean contains(Element element) {
        if (element instanceof Position) {
            return this.center.distanceTo(element, this.cs) <= this.radius;
        }
        if (element instanceof Circle) {
            Circle c = (Circle)element;
            if (c.cs != this.cs) {
                throw new IllegalArgumentException("Cannot compare circles in different coordinate systems");
            }
            return this.center.distanceTo(c.center, this.cs) <= this.radius + c.radius;
        }
        return super.contains(element);
    }

    public boolean equals(Circle other) {
        return other == this || other != null && this.center.equals(other.center) && this.radius == other.radius;
    }

    public boolean equals(Object other) {
        return other instanceof Circle && this.equals((Circle)other);
    }

    @Override
    public double geodesicDistanceTo(Element other) {
        if (other instanceof Position) {
            return Math.max(0.0, this.center.geodesicDistanceTo(other) - this.radius);
        }
        return super.geodesicDistanceTo(other);
    }

    public Position getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public int hashCode() {
        return this.center.hashCode() ^ new Double(this.radius).hashCode();
    }

    @Override
    public double rhumbLineDistanceTo(Element other) {
        if (other instanceof Position) {
            return Math.max(0.0, this.center.rhumbLineDistanceTo(other) - this.radius);
        }
        return super.rhumbLineDistanceTo(other);
    }

    public Circle withCenter(Position center) {
        return new Circle(center, this.radius, this.cs);
    }

    public Circle withRadius(double radius) {
        return new Circle(this.center, radius, this.cs);
    }
}

