/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.geometry;

import dk.dma.enav.model.geometry.Area;
import dk.dma.enav.model.geometry.CoordinateSystem;
import dk.dma.enav.model.geometry.Element;
import dk.dma.enav.model.geometry.Position;
import dk.dma.enav.util.CoordinateConverter;
import dk.dma.enav.util.compass.CompassUtils;
import dk.dma.enav.util.geometry.Point;
import java.util.ArrayList;
import java.util.List;

public final class Ellipse
extends Area {
    private final Position geodeticReference;
    private final double dx;
    private final double dy;
    private final double alpha;
    private final double beta;
    private final double thetaDeg;
    private final CoordinateConverter coordinateConverter;

    public Ellipse(Position geodeticReference, double alpha, double beta, double thetaDeg, CoordinateSystem cs) {
        super(cs);
        this.geodeticReference = geodeticReference;
        this.coordinateConverter = geodeticReference == null ? null : new CoordinateConverter(geodeticReference.longitude, geodeticReference.latitude);
        this.dx = 0.0;
        this.dy = 0.0;
        this.alpha = alpha;
        this.beta = beta;
        this.thetaDeg = thetaDeg;
    }

    public Ellipse(Position geodeticReference, double dx, double dy, double alpha, double beta, double thetaDeg, CoordinateSystem cs) {
        super(cs);
        this.geodeticReference = geodeticReference;
        this.coordinateConverter = geodeticReference == null ? null : new CoordinateConverter(geodeticReference.longitude, geodeticReference.latitude);
        this.dx = dx;
        this.dy = dy;
        this.alpha = alpha;
        this.beta = beta;
        this.thetaDeg = thetaDeg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Ellipse{");
        sb.append("geodeticReference=").append(this.geodeticReference);
        sb.append(", dx=").append(this.dx);
        sb.append(", dy=").append(this.dy);
        sb.append(", alpha=").append(this.alpha);
        sb.append(", beta=").append(this.beta);
        sb.append(", thetaDeg=").append(this.thetaDeg);
        sb.append('}');
        return sb.toString();
    }

    public Position getGeodeticReference() {
        return this.geodeticReference;
    }

    public double getX() {
        return this.dx;
    }

    public double getY() {
        return this.dy;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public double getThetaDeg() {
        return this.thetaDeg;
    }

    @Override
    public boolean intersects(Element otherElement) {
        if (otherElement instanceof Ellipse) {
            return this.intersects((Ellipse)otherElement);
        }
        throw new UnsupportedOperationException("Can not compute intersection between ellipse and " + otherElement.getClass().getSimpleName() + ".");
    }

    private boolean intersects(Ellipse otherEllipse) {
        double h1x = StrictMath.cos(StrictMath.toRadians(this.thetaDeg));
        double h1y = StrictMath.sin(StrictMath.toRadians(this.thetaDeg));
        double h2x = StrictMath.cos(StrictMath.toRadians(otherEllipse.thetaDeg));
        double h2y = StrictMath.sin(StrictMath.toRadians(otherEllipse.thetaDeg));
        double vx = otherEllipse.dx - this.dx;
        double vy = otherEllipse.dy - this.dy;
        double d = StrictMath.sqrt(vx * vx + vy * vy);
        boolean intersects = true;
        double SMALL_NUM = 0.1;
        if (d > 0.1) {
            double cosb1 = (h1x * vx + h1y * vy) / (StrictMath.sqrt(h1x * h1x + h1y * h1y) * d);
            double sinb1 = (h1x * vy - h1y * vx) / (StrictMath.sqrt(h1x * h1x + h1y * h1y) * d);
            double d1 = StrictMath.sqrt(this.alpha * this.alpha * this.beta * this.beta / (this.alpha * this.alpha * sinb1 * sinb1 + this.beta * this.beta * cosb1 * cosb1));
            double cosb2 = (h2x * vx + h2y * vy) / (StrictMath.sqrt(h2x * h2x + h2y * h2y) * d);
            double sinb2 = (h2x * vy - h2y * vx) / (StrictMath.sqrt(h2x * h2x + h2y * h2y) * d);
            double d2 = StrictMath.sqrt(otherEllipse.alpha * otherEllipse.alpha * otherEllipse.beta * otherEllipse.beta / (otherEllipse.alpha * otherEllipse.alpha * sinb2 * sinb2 + otherEllipse.beta * otherEllipse.beta * cosb2 * cosb2));
            intersects = d - d1 - d2 < 0.0;
        }
        return intersects;
    }

    @Override
    public boolean contains(Element otherElement) {
        if (otherElement instanceof Position) {
            return this.contains((Position)otherElement);
        }
        throw new UnsupportedOperationException("Can not compute whether ellipse contains a " + otherElement.getClass().getSimpleName() + ".");
    }

    private boolean contains(Position position) {
        double y;
        double x = this.coordinateConverter.lon2x(position.getLongitude(), position.getLatitude());
        Point p = new Point(x, y = this.coordinateConverter.lat2y(position.getLongitude(), position.getLatitude())).rotate(Point.ORIGIN, -this.thetaDeg);
        return StrictMath.pow(p.getX(), 2.0) / StrictMath.pow(this.alpha, 2.0) + StrictMath.pow(p.getY(), 2.0) / StrictMath.pow(this.beta, 2.0) <= 1.0;
    }

    public List<Position> samplePerimeter(int n) {
        ArrayList<Point> unitPerimeter = new ArrayList<Point>(n);
        double pi2 = Math.PI * 2;
        double dtheta = pi2 / (double)n;
        double theta = 0.0;
        do {
            unitPerimeter.add(new Point(this.alpha * StrictMath.cos(theta), this.beta * StrictMath.sin(theta)));
        } while ((theta += dtheta) < pi2);
        ArrayList<Point> rotatedPerimeter = new ArrayList<Point>(n);
        for (Point point : unitPerimeter) {
            Point pr = point.rotate(Point.ORIGIN, this.thetaDeg).translate(this.dx, this.dy);
            rotatedPerimeter.add(pr);
        }
        ArrayList<Position> perimeter = new ArrayList<Position>(n);
        for (Point point : rotatedPerimeter) {
            double lon = this.coordinateConverter.x2Lon(point.getX(), point.getY());
            double lat = this.coordinateConverter.y2Lat(point.getX(), point.getY());
            perimeter.add(Position.create(lat, lon));
        }
        return perimeter;
    }

    public double getMajorAxisGeodeticHeading() {
        return CompassUtils.cartesian2compass((double)this.thetaDeg);
    }
}

