/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.geometry;

import dk.dma.enav.model.geometry.CoordinateSystem;
import dk.dma.enav.model.geometry.Element;
import dk.dma.enav.model.geometry.Position;
import java.util.Objects;

public class Line
implements Element {
    private static final long serialVersionUID = 1L;
    final CoordinateSystem cs;
    final Position end;
    final Position start;

    Line(Position start, Position end, CoordinateSystem system) {
        this.start = Objects.requireNonNull(start, "start is null");
        this.end = Objects.requireNonNull(end, "end is null");
        this.cs = Objects.requireNonNull(system);
    }

    @Override
    public double distanceTo(Element position, CoordinateSystem system) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Line other) {
        return other == this || other != null && this.start.equals(other.start) && this.start.equals(other.start) && this.cs == other.cs;
    }

    public boolean equals(Object other) {
        return other instanceof Line && this.equals((Line)other);
    }

    @Override
    public double geodesicDistanceTo(Element other) {
        throw new UnsupportedOperationException();
    }

    public final CoordinateSystem getCoordinateSystem() {
        return this.cs;
    }

    public Position getEnd() {
        return this.end;
    }

    public double getLength() {
        return this.start.distanceTo(this.end, this.cs);
    }

    public Position getStart() {
        return this.start;
    }

    public int hashCode() {
        return this.end.hashCode() ^ this.start.hashCode();
    }

    @Override
    public double rhumbLineDistanceTo(Element other) {
        throw new UnsupportedOperationException();
    }
}

