/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.geometry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import dk.dma.enav.model.dto.PositionDTO;
import dk.dma.enav.model.geometry.CoordinateSystem;
import dk.dma.enav.model.geometry.Element;
import dk.dma.enav.model.geometry.PositionTime;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Position
implements Element {
    static final double EARTH_RADIUS = 6371.0;
    private static final long serialVersionUID = 1L;
    final double latitude;
    final double longitude;

    Position(double latitude, double longitude) {
        Position.verifyLatitude(latitude);
        Position.verifyLongitude(longitude);
        this.latitude = latitude == -0.0 ? 0.0 : latitude;
        this.longitude = longitude == -0.0 ? 0.0 : longitude;
    }

    @Override
    public double distanceTo(Element other, CoordinateSystem system) {
        return Objects.requireNonNull(system) == CoordinateSystem.CARTESIAN ? this.rhumbLineDistanceTo(other) : this.geodesicDistanceTo(other);
    }

    public boolean equals(Object other) {
        return other instanceof Position && this.equals((Position)other);
    }

    public boolean equals(Position other) {
        return other == this || other != null && this.latitude == other.latitude && this.longitude == other.longitude;
    }

    @Override
    public double geodesicDistanceTo(Element other) {
        if (other instanceof Position) {
            return CoordinateSystem.GEODETIC.distanceBetween(this, (Position)other);
        }
        return other.geodesicDistanceTo(this);
    }

    public double geodesicFinalBearingTo(Position location) {
        return CoordinateSystem.vincentyFormula(this.getLatitude(), this.getLongitude(), location.getLatitude(), location.getLongitude(), CoordinateSystem.VincentyCalculationType.FINAL_BEARING);
    }

    public double geodesicInitialBearingTo(Position location) {
        return CoordinateSystem.vincentyFormula(this.getLatitude(), this.getLongitude(), location.getLatitude(), location.getLongitude(), CoordinateSystem.VincentyCalculationType.INITIAL_BEARING);
    }

    public long getCell(double degress) {
        if (degress < 1.0E-4) {
            throw new IllegalArgumentException("degress = " + degress);
        }
        if (degress > 100.0) {
            throw new IllegalArgumentException("degress = " + degress);
        }
        return (long)(Math.floor(this.getLatitude() / degress) * (360.0 / degress)) + (long)((360.0 + this.getLongitude()) / degress) - (long)(360.0 / degress);
    }

    public int getCellInt(double degrees) {
        if (degrees < 0.01) {
            throw new IllegalArgumentException("degrees = " + degrees);
        }
        return (int)this.getCell(degrees);
    }

    public double getLatitude() {
        return this.latitude;
    }

    public String getLatitudeAsString() {
        double lat = this.latitude;
        if (lat < 0.0) {
            lat *= -1.0;
        }
        int hours = (int)lat;
        lat -= (double)hours;
        lat *= 60.0;
        StringBuilder latitudeAsString = new StringBuilder(16);
        latitudeAsString.append(Position.format00(hours));
        latitudeAsString.append(" ");
        latitudeAsString.append(Position.format00((int)lat));
        latitudeAsString.append(".");
        latitudeAsString.append(Position.format000((int)Math.round(1000.0 * (lat - (double)((int)lat)))));
        latitudeAsString.append(this.latitude < 0.0 ? "S" : "N");
        return latitudeAsString.toString();
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getLongitudeAsString() {
        double lon = this.longitude;
        if (lon < 0.0) {
            lon *= -1.0;
        }
        int hours = (int)lon;
        lon -= (double)hours;
        lon *= 60.0;
        StringBuilder longitudeAsString = new StringBuilder(16);
        longitudeAsString.append(Position.format000(hours));
        longitudeAsString.append(" ");
        longitudeAsString.append(Position.format00((int)lon));
        longitudeAsString.append(".");
        longitudeAsString.append(Position.format000((int)Math.round(1000.0 * (lon - (double)((int)lon)))));
        longitudeAsString.append(this.longitude < 0.0 ? "W" : "E");
        return longitudeAsString.toString();
    }

    private static String format000(int value) {
        if (value < 10) {
            return "00" + value;
        }
        if (value < 100) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    private static String format00(int value) {
        if (value < 10) {
            return "0" + value;
        }
        return Integer.toString(value);
    }

    public int hashCode() {
        long latLong = Double.doubleToLongBits(this.latitude);
        long lonLong = Double.doubleToLongBits(this.longitude);
        return (int)(latLong ^ latLong >>> 32) ^ (int)(lonLong ^ lonLong >>> 32);
    }

    public double rhumbLineBearingTo(Position position) {
        double lat1 = Math.toRadians(this.latitude);
        double lat2 = Math.toRadians(position.latitude);
        double dPhi = Math.log(Math.tan(lat2 / 2.0 + 0.7853981633974483) / Math.tan(lat1 / 2.0 + 0.7853981633974483));
        double dLon = Math.toRadians(position.longitude - this.longitude);
        if (Math.abs(dLon) > Math.PI) {
            dLon = dLon > 0.0 ? -(Math.PI * 2 - dLon) : Math.PI * 2 + dLon;
        }
        double brng = Math.atan2(dLon, dPhi);
        return (Math.toDegrees(brng) + 360.0) % 360.0;
    }

    @Override
    public double rhumbLineDistanceTo(Element other) {
        if (other instanceof Position) {
            return CoordinateSystem.CARTESIAN.distanceBetween(this, (Position)other);
        }
        return other.rhumbLineDistanceTo(this);
    }

    public Position positionAt(double bearing, double distance) {
        double d = distance / 6371000.0;
        double bearingRad = Math.toRadians(bearing);
        double lat1Rad = Math.toRadians(this.latitude);
        double lon1Rad = Math.toRadians(this.longitude);
        double lat2Rad = Math.asin(Math.sin(lat1Rad) * Math.cos(d) + Math.cos(lat1Rad) * Math.sin(d) * Math.cos(bearingRad));
        double a = Math.atan2(Math.sin(bearingRad) * Math.sin(d) * Math.cos(lat1Rad), Math.cos(d) - Math.sin(lat1Rad) * Math.sin(lat2Rad));
        double lon2Rad = (lon1Rad + a + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        double lat2 = Math.toDegrees(lat2Rad);
        double lon2 = Math.toDegrees(lon2Rad);
        return Position.create(lat2, lon2);
    }

    public long toPackedLong() {
        float lat = (float)this.getLatitude();
        float lon = (float)this.getLongitude();
        return ((long)Float.floatToRawIntBits(lat) << 32) + (long)Float.floatToRawIntBits(lon);
    }

    public String toString() {
        return "(" + this.getLatitudeAsString() + ", " + this.getLongitudeAsString() + ")";
    }

    public Position withLatitude(double latitude) {
        return new Position(latitude, this.longitude);
    }

    public Position withLongitude(double longitude) {
        return new Position(this.latitude, longitude);
    }

    public PositionTime withTime(long time) {
        return PositionTime.create(this, time);
    }

    @JsonCreator
    public static Position create(@JsonProperty(value="latitude") double latitude, @JsonProperty(value="longitude") double longitude) {
        return new Position(latitude, longitude);
    }

    public static Position fromPackedLong(long l) {
        return new Position(Float.intBitsToFloat((int)(l >> 32)), Float.intBitsToFloat((int)l));
    }

    public static boolean isValid(double latitude, double longitude) {
        return latitude <= 90.0 && latitude >= -90.0 && longitude <= 180.0 && longitude >= -180.0;
    }

    public static void verifyLatitude(double latitude) {
        if (latitude > 90.0 || latitude < -90.0) {
            throw new IllegalArgumentException("Illegal latitude must be between -90 and 90, was " + latitude);
        }
    }

    public static void verifyLongitude(double longitude) {
        if (longitude > 180.0 || longitude < -180.0) {
            throw new IllegalArgumentException("Longitude must be between -180 and 180, was " + longitude);
        }
    }

    public PositionDTO getDTO() {
        return new PositionDTO(this.latitude, this.longitude);
    }
}

