/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.geometry;

import dk.dma.enav.model.geometry.Position;
import dk.dma.enav.util.CoordinateConverter;
import dk.dma.enav.util.compass.CompassUtils;
import java.util.Objects;

public class PositionTime
extends Position {
    private static final long serialVersionUID = 1L;
    private final long time;

    public PositionTime(double latitude, double longitude, long time) {
        super(latitude, longitude);
        this.time = time;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof PositionTime && this.equals((PositionTime)other);
    }

    @Override
    public boolean equals(Position other) {
        return other instanceof PositionTime && this.equals((PositionTime)other);
    }

    public boolean positionEquals(Position other) {
        return super.equals(other);
    }

    public boolean equals(PositionTime other) {
        return super.equals(other) && this.time == other.time;
    }

    @Override
    public int hashCode() {
        long latLong = Double.doubleToLongBits(this.latitude);
        long lonLong = Double.doubleToLongBits(this.longitude);
        return (int)(this.time ^ latLong ^ latLong >>> 32) ^ (int)(this.time ^ lonLong ^ lonLong >>> 32);
    }

    public long getTime() {
        return this.time;
    }

    public static PositionTime create(Position position, long time) {
        return PositionTime.create(position.latitude, position.longitude, time);
    }

    public static PositionTime create(double latitude, double longitude, long time) {
        return new PositionTime(latitude, longitude, time);
    }

    public static PositionTime createExtrapolated(PositionTime pt1, float cog, float sog, long time) {
        Objects.requireNonNull(pt1);
        if (time < pt1.getTime()) {
            throw new IllegalArgumentException("'time' arguments cannot be earlier than 'pt1'. " + time + " " + pt1.getTime());
        }
        CoordinateConverter coordinateConverter = new CoordinateConverter(pt1.getLongitude(), pt1.getLatitude());
        double x0 = coordinateConverter.lon2x(pt1.getLongitude(), pt1.getLatitude());
        double y0 = coordinateConverter.lat2y(pt1.getLongitude(), pt1.getLatitude());
        int dt = (int)((time - pt1.getTime()) / 1000L);
        double dist = (double)((float)dt * sog) * 0.5144;
        double angle = CompassUtils.compass2cartesian((double)cog);
        double dx = Math.cos(angle / 180.0 * Math.PI) * dist;
        double dy = Math.sin(angle / 180.0 * Math.PI) * dist;
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        double lon1 = coordinateConverter.x2Lon(x1, y1);
        double lat1 = coordinateConverter.y2Lat(x1, y1);
        return PositionTime.create(lat1, lon1, time);
    }

    public static PositionTime createInterpolated(PositionTime pt1, PositionTime pt2, long time) {
        Objects.requireNonNull(pt1);
        Objects.requireNonNull(pt2);
        if (pt2.getTime() < pt1.getTime()) {
            throw new IllegalArgumentException("Provided position 1 must be earlier than position 2." + pt1.getTime() + " " + pt2.getTime());
        }
        if (time < pt1.getTime()) {
            throw new IllegalArgumentException("time parameter must be later than position 1's. " + time + " " + pt1.getTime());
        }
        if (time > pt2.getTime()) {
            throw new IllegalArgumentException("time parameter must be earlier than position 2's. " + time + " " + pt2.getTime());
        }
        double interpolatedLatitude = PositionTime.linearInterpolation(pt1.getLatitude(), pt1.getTime(), pt2.getLatitude(), pt2.getTime(), time);
        double interpolatedLongitude = PositionTime.linearInterpolation(pt1.getLongitude(), pt1.getTime(), pt2.getLongitude(), pt2.getTime(), time);
        return PositionTime.create(interpolatedLatitude, interpolatedLongitude, time);
    }

    static final double linearInterpolation(double y1, long x1, double y2, long x2, long x) {
        return y1 + (y2 - y1) / (double)(x2 - x1) * (double)(x - x1);
    }
}

