/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.geometry.grid;

import dk.dma.enav.model.geometry.Area;
import dk.dma.enav.model.geometry.BoundingBox;
import dk.dma.enav.model.geometry.CoordinateSystem;
import dk.dma.enav.model.geometry.Position;
import dk.dma.enav.model.geometry.grid.Cell;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;

public final class Grid {
    public static final Grid GRID_1_DEGREE = new Grid(1.0);
    public static final Grid GRID_10_DEGREES = new Grid(10.0);
    private final double resolution;
    final double multiplier;

    private Grid(double resolution) {
        this.resolution = resolution;
        this.multiplier = 360.0 / resolution;
    }

    public double getResolution() {
        return this.resolution;
    }

    public double getSize() {
        return 4.0075E7 * this.resolution / 360.0;
    }

    public Cell getCell(long cellId) {
        return new Cell(cellId);
    }

    public Cell getCell(Position pos) {
        return this.getCell(pos.getLatitude(), pos.getLongitude());
    }

    public Cell getCell(double lat, double lon) {
        return new Cell((long)(Math.floor(lat / this.resolution) * this.multiplier) + (long)((360.0 + lon) / this.resolution) - (long)(360.0 / this.resolution));
    }

    public Position getGeoPosOfCell(Cell cell) {
        long id = cell.getCellId();
        long latPart = (long)Math.floor((double)(id += (long)(360.0 / this.resolution / 2.0)) / this.multiplier);
        long lonPart = (long)((double)(id -= (long)(360.0 / this.resolution / 2.0)) - (double)latPart * this.multiplier);
        return Position.create(this.resolution * (double)latPart, this.resolution * (double)lonPart);
    }

    public Cell getCellNorthOf(Cell cell) {
        return new Cell((long)((double)cell.getCellId() + this.multiplier));
    }

    public Cell getCellSouthOf(Cell cell) {
        return new Cell((long)((double)cell.getCellId() - this.multiplier));
    }

    public Cell getCellWestOf(Cell cell) {
        if ((double)cell.getCellId() % this.multiplier == 0.0) {
            return new Cell((long)((double)cell.getCellId() + this.multiplier - 1.0));
        }
        return new Cell(cell.getCellId() - 1L);
    }

    public Cell getCellEastOf(Cell cell) {
        if ((double)cell.getCellId() % this.multiplier == this.multiplier - 1.0) {
            return new Cell((long)((double)cell.getCellId() - this.multiplier + 1.0));
        }
        return new Cell(cell.getCellId() + 1L);
    }

    public BoundingBox getBoundingBoxOfCell(Cell cell) {
        Position southWestCorner = this.getGeoPosOfCell(cell);
        Position northEastCorner = Position.create(southWestCorner.getLatitude() + this.resolution, southWestCorner.getLongitude() + this.resolution);
        return BoundingBox.create(southWestCorner, northEastCorner, CoordinateSystem.GEODETIC);
    }

    public Set<Cell> getNearbyCells(Position position, double radius) {
        HashSet<Cell> cells = new HashSet<Cell>();
        double latN = position.getLatitude() + radius;
        double latS = position.getLatitude() - radius;
        double lonW = position.getLongitude() - radius;
        double lonE = position.getLongitude() + radius;
        Long cellIdNW = this.getCell((double)latN, (double)lonW).id;
        Long cellIdNE = this.getCell((double)latN, (double)lonE).id;
        Long cellIdSE = this.getCell((double)latS, (double)lonE).id;
        Long firstCellId = cellIdNW;
        Long iteratorCellId = cellIdNW;
        Long lastCellId = cellIdNE;
        while (iteratorCellId <= lastCellId) {
            iteratorCellId = firstCellId;
            cells.add(new Cell(firstCellId));
            while (iteratorCellId <= lastCellId) {
                iteratorCellId = this.getCellEastOf((Cell)new Cell((long)iteratorCellId.longValue())).id;
                cells.add(new Cell(iteratorCellId));
            }
            firstCellId = this.getCellSouthOf((Cell)new Cell((long)firstCellId.longValue())).id;
            lastCellId = this.getCellSouthOf((Cell)new Cell((long)lastCellId.longValue())).id;
        }
        if (cellIdNW == cellIdSE) {
            cells.add(new Cell(cellIdNW));
        }
        return cells;
    }

    public Set<Cell> getCells(Area area) {
        if (area instanceof BoundingBox) {
            return this.getCells((BoundingBox)area);
        }
        throw new UnsupportedOperationException("Only bounding boxes are supported");
    }

    Set<Cell> getCells(BoundingBox box) {
        TreeSet<Long> cells = new TreeSet<Long>();
        int steps = 64;
        int prev = 0;
        while (true) {
            for (int i = 0; i < steps; ++i) {
                cells.add(box.getRandom().getCell(this.resolution));
            }
            if (cells.size() == prev) break;
            prev = cells.size();
            steps *= 2;
        }
        TreeSet<Cell> result = new TreeSet<Cell>();
        for (Long l : cells) {
            result.add(new Cell(l));
        }
        return result;
    }

    public static Grid create(double resolution) {
        return new Grid(resolution);
    }

    public static Grid createSize(double approxSize) {
        return Grid.create(360.0 * approxSize / 4.0075E7);
    }

    public static void main(String[] args) {
        BoundingBox bb = BoundingBox.create(Position.create(-40.0, 15.0), Position.create(12.0, 77.0), CoordinateSystem.CARTESIAN);
        TreeSet<Long> cells = new TreeSet<Long>();
        for (int i = 0; i < 100000; ++i) {
            cells.add(bb.getRandom().getCell(1.0));
        }
        System.out.println(cells.size());
        System.out.println(cells);
    }
}

