/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.voyage;

public enum NavigationalStatus {
    AGROUND,
    AIS_SART{

        @Override
        public String toString() {
            return this.name().replace("_", "-");
        }
    }
    ,
    AT_ANCHOR,
    CONSTRAINED_BY_HER_DRAUGHT,
    ENGAGED_IN_FISHING,
    MOORED,
    NOT_UNDER_COMMAND,
    RESTRICTED_MANOEUVRABILITY,
    SAILING,
    UNDEFINED,
    UNDER_WAY,
    UNDER_WAY_USING_ENGINE;


    public String toString() {
        String navStat = this.name().replace("_", " ");
        return navStat.substring(0, 1) + navStat.substring(1).toLowerCase();
    }

    public static NavigationalStatus fromAIS(int aisNavStatus) {
        switch (aisNavStatus) {
            case 0: {
                return UNDER_WAY_USING_ENGINE;
            }
            case 1: {
                return AT_ANCHOR;
            }
            case 2: {
                return NOT_UNDER_COMMAND;
            }
            case 3: {
                return RESTRICTED_MANOEUVRABILITY;
            }
            case 4: {
                return CONSTRAINED_BY_HER_DRAUGHT;
            }
            case 5: {
                return MOORED;
            }
            case 6: {
                return AGROUND;
            }
            case 7: {
                return ENGAGED_IN_FISHING;
            }
            case 8: {
                return UNDER_WAY;
            }
            case 14: {
                return AIS_SART;
            }
        }
        return UNDEFINED;
    }

    public static void main(String[] args) {
        System.out.println(AIS_SART.toString());
        System.out.println(AT_ANCHOR.toString());
    }
}

