/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.model.voyage.endpoint;

import java.util.Objects;
import java.util.regex.Pattern;

public final class UnLocode {
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z]{2}[a-zA-z2-9]{3}");
    private final String unlocode;

    public UnLocode(String unlocode) {
        this.unlocode = Objects.requireNonNull(unlocode, "unlocode is null").toUpperCase();
        if (!PATTERN.matcher(unlocode).matches()) {
            throw new IllegalArgumentException(unlocode + " is not a valid UN/LOCODE (does not match pattern)");
        }
    }

    public boolean equals(Object other) {
        return other instanceof UnLocode && this.equals((UnLocode)other);
    }

    public boolean equals(UnLocode other) {
        return other == this || other != null && this.unlocode.equals(other.unlocode);
    }

    public int hashCode() {
        return this.unlocode.hashCode();
    }
}

