/*
 * Decompiled with CFR 0.152.
 */
package dk.dma.enav.safety;

import dk.dma.enav.model.geometry.CoordinateSystem;
import dk.dma.enav.model.geometry.Ellipse;
import dk.dma.enav.model.geometry.Position;
import dk.dma.enav.util.CoordinateConverter;
import dk.dma.enav.util.compass.CompassUtils;
import dk.dma.enav.util.geometry.Point;

public final class SafetyZones {
    public static Ellipse vesselExtent(Position position, float hdg, float loa, float beam, float dimStern, float dimStarboard) {
        return SafetyZones.vesselExtent(position, position, hdg, loa, beam, dimStern, dimStarboard);
    }

    public static Ellipse vesselExtent(Position geodeticReference, Position position, float hdg, float loa, float beam, float dimStern, float dimStarboard) {
        return SafetyZones.createEllipse(geodeticReference, position, hdg, loa, beam, dimStern, dimStarboard, 1.0, 1.0, 0.5);
    }

    public static Ellipse safetyZone(Position geodeticReference, Position position, float cog, float sog, float loa, float beam, float dimStern, float dimStarboard) {
        double safetyEllipseLength = 2.0;
        double safetyEllipseBreadth = 3.0;
        double safetyEllipseBehind = 0.25;
        double v = 1.0;
        double l1 = Math.max(2.0, 1.5);
        double b1 = Math.max(3.0, 1.5);
        double xc = -0.25 + 0.5 * l1;
        return SafetyZones.createEllipse(geodeticReference, position, cog, loa, beam, dimStern, dimStarboard, l1, b1, xc);
    }

    public static Ellipse createEllipse(Position geodeticReference, Position position, float direction, float loa, float beam, float dimStern, float dimStarboard, double l1, double b1, double xc) {
        double thetaDeg = CompassUtils.compass2cartesian((double)direction);
        double centerLatitude = geodeticReference.getLatitude();
        double centerLongitude = geodeticReference.getLongitude();
        CoordinateConverter CoordinateConverter2 = new CoordinateConverter(centerLongitude, centerLatitude);
        double trackLatitude = position.getLatitude();
        double trackLongitude = position.getLongitude();
        double x = CoordinateConverter2.lon2x(trackLongitude, trackLatitude);
        double y = CoordinateConverter2.lat2y(trackLongitude, trackLatitude);
        Point pt0 = new Point(x, y);
        Point pt1 = new Point(pt0.getX() - (double)dimStern + (double)loa * xc, pt0.getY() + (double)dimStarboard - (double)beam / 2.0);
        pt1 = pt1.rotate(pt0, thetaDeg);
        double alpha = (double)loa * l1 / 2.0;
        double beta = (double)beam * b1 / 2.0;
        return new Ellipse(geodeticReference, pt1.getX(), pt1.getY(), alpha, beta, thetaDeg, CoordinateSystem.CARTESIAN);
    }
}

