/*
 * Decompiled with CFR 0.152.
 */
package dk.eSoftware.commandLineParser.generalized;

import dk.eSoftware.commandLineParser.CommandLineParser;
import dk.eSoftware.commandLineParser.Configuration;
import dk.eSoftware.commandLineParser.UnknownCommandException;
import dk.eSoftware.commandLineParser.generalized.FieldMappingException;
import dk.eSoftware.commandLineParser.generalized.FieldValuePair;
import dk.eSoftware.commandLineParser.generalized.ReflectionException;
import dk.eSoftware.commandLineParser.generalized.ReflectionWrapper;
import dk.eSoftware.commandLineParser.generalized.documentation.HelpUtilities;

public class GeneralConfigurationBuilder<T extends Configuration>
implements CommandLineParser.ConfigBuilder<T> {
    private final Class<T> configurationClass;
    private final ReflectionWrapper<T> wrapper;

    public GeneralConfigurationBuilder(Class<T> configurationClass) {
        this.configurationClass = configurationClass;
        try {
            Configuration configuration = (Configuration)configurationClass.newInstance();
            this.wrapper = new ReflectionWrapper<Configuration>(configuration, configurationClass);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Failed to instantiate new instance of class: " + configurationClass.getSimpleName() + " make sure it has zero-args constructor");
        }
    }

    @Override
    public void applyCommand(CommandLineParser.Command command) throws UnknownCommandException {
        FieldValuePair fieldValuePair = this.convertToValuePair(command);
        try {
            this.wrapper.writeField(fieldValuePair.getField(), fieldValuePair.getValue());
        }
        catch (ReflectionException e) {
            throw new FieldMappingException("Failed writing command: " + fieldValuePair + " to class: " + this.configurationClass.getSimpleName());
        }
    }

    private FieldValuePair convertToValuePair(CommandLineParser.Command command) throws FieldMappingException {
        String commandString = command.getCommand();
        if (commandString.contains("=")) {
            if (command.getParams().isEmpty()) {
                String[] split = commandString.split("=");
                if (split.length == 2) {
                    return new FieldValuePair(split[0], split[1]);
                }
                throw new FieldMappingException("When using '=' there must only be a single occurrence");
            }
            throw new FieldMappingException("When using '=' a value cannot be specified with '-value' as well");
        }
        if (command.getParams().size() == 1) {
            return new FieldValuePair(commandString, command.getParams().get(0));
        }
        throw new FieldMappingException("Failed to map command " + commandString + " to a field, must have exactly one specified value");
    }

    @Override
    public T build() {
        return (T)((Configuration)this.wrapper.getObject());
    }

    @Override
    public String help() {
        return HelpUtilities.generateHelpString(this.configurationClass);
    }
}

