/*
 * Decompiled with CFR 0.152.
 */
package dk.eSoftware.commandLineParser.generalized;

import dk.eSoftware.commandLineParser.generalized.ReflectionException;
import dk.eSoftware.commandLineParser.generalized.annotations.MapConfiguration;
import dk.eSoftware.commandLineParser.generalized.annotations.Name;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

class ReflectionWrapper<T> {
    private final Class<T> innerClass;
    private final T object;
    private final Map<Class<?>, Map<String, Field>> fieldMaps;

    public ReflectionWrapper(T configuration, Class<T> innerClass) {
        this.object = configuration;
        this.innerClass = innerClass;
        this.fieldMaps = new HashMap();
        this.fieldMaps.put(innerClass, this.buildNameMap(innerClass));
    }

    private Map<String, Field> buildNameMap(Class<?> innerClass) {
        HashMap<String, Field> result = new HashMap<String, Field>();
        for (Field field : innerClass.getDeclaredFields()) {
            result.putIfAbsent(field.getName(), field);
            Name nameAnnotation = field.getAnnotation(Name.class);
            if (nameAnnotation == null) continue;
            result.put(nameAnnotation.name(), field);
        }
        return result;
    }

    void writeField(String fieldName, String serializedValue) throws ReflectionException {
        this.writeFieldInner(fieldName, serializedValue, this.innerClass, this.object);
    }

    private void writeFieldInner(String fieldName, String serializedValue, Class<?> objectClass, Object object) throws ReflectionException {
        try {
            if (fieldName.contains(".")) {
                String[] split = fieldName.split("\\.", 2);
                String currentFieldName = split[0];
                Field field = this.getField(objectClass, currentFieldName);
                boolean originallyAccessible = field.isAccessible();
                field.setAccessible(true);
                Object fieldObject = field.get(object);
                Class<?> fieldType = field.getType();
                if (Map.class.isAssignableFrom(fieldType)) {
                    field.set(object, this.handleMap(field, fieldObject, split[1], serializedValue));
                } else {
                    if (fieldObject == null) {
                        fieldObject = fieldType.newInstance();
                        field.set(object, fieldObject);
                    }
                    this.writeFieldInner(split[1], serializedValue, fieldType, fieldObject);
                }
                field.setAccessible(originallyAccessible);
            } else {
                Field field = this.getField(objectClass, fieldName);
                if (Modifier.isStatic(field.getModifiers())) {
                    throw new ReflectionException("Unable to write value to static field '" + fieldName + "' in class: '" + objectClass.getSimpleName() + "'");
                }
                boolean originallyAccessible = field.isAccessible();
                field.setAccessible(true);
                Class<?> type = field.getType();
                if (type.isPrimitive()) {
                    this.writePrimitiveType(type, object, field, serializedValue);
                } else {
                    this.writeComplex(type, object, field, serializedValue);
                }
                field.setAccessible(originallyAccessible);
            }
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | NumberFormatException | InvocationTargetException e) {
            throw new ReflectionException("Failed writing field: " + fieldName + " to class: " + objectClass.getSimpleName());
        }
        catch (InstantiationException e) {
            throw new ReflectionException("Failed creating a new instance of field type - ensure that they all have zero-args constructors");
        }
    }

    private Object handleMap(Field field, Object fieldObject, String serializedKey, String serializedValue) throws ReflectionException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        MapConfiguration mapAnnotation = this.getMapConfiguration(field);
        Class<? extends Map> mapClass = mapAnnotation.mapClass();
        if (fieldObject == null) {
            fieldObject = mapClass.newInstance();
        }
        Method put = mapClass.getMethod("put", Object.class, Object.class);
        put.invoke(fieldObject, this.deserializedComplex(mapAnnotation.keyClass(), serializedKey, "Map: " + serializedKey), this.deserializedComplex(mapAnnotation.valueClass(), serializedValue, "Map: " + serializedKey));
        return fieldObject;
    }

    private MapConfiguration getMapConfiguration(Field field) throws ReflectionException {
        MapConfiguration mapAnnotation = field.getAnnotation(MapConfiguration.class);
        if (mapAnnotation == null) {
            throw new ReflectionException("Usage of Map requires usage of the MapConfiguration annotation");
        }
        return mapAnnotation;
    }

    private Field getField(Class<?> objectClass, String currentFieldName) throws NoSuchFieldException {
        Field field = (Field)this.fieldMaps.computeIfAbsent(objectClass, this::buildNameMap).get(currentFieldName);
        if (field == null) {
            throw new NoSuchFieldException("Found no field with name: '" + currentFieldName + "' in object: '" + objectClass.getSimpleName() + "'");
        }
        return field;
    }

    private <I> void writeComplex(Class<?> type, I object, Field field, String value) throws IllegalAccessException, ReflectionException {
        field.set(object, this.deserializedComplex(type, value, field.getName()));
    }

    private Object deserializedComplex(Class<?> type, String value, String field) throws ReflectionException {
        if (String.class.equals(type)) {
            return value;
        }
        if (Boolean.class.equals(type)) {
            return Boolean.parseBoolean(value);
        }
        if (Integer.class.equals(type)) {
            return Integer.parseInt(value);
        }
        if (Float.class.equals(type)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, value);
        }
        throw new ReflectionException("Failed writing field: " + field + " to class: " + type.getSimpleName() + " type " + type + " was unsupported");
    }

    private <I> void writePrimitiveType(Class<?> type, I object, Field field, String value) throws IllegalAccessException, ReflectionException {
        if (Boolean.TYPE.equals(type)) {
            field.setBoolean(object, Boolean.parseBoolean(value));
        } else if (Integer.TYPE.equals(type)) {
            field.setInt(object, Integer.parseInt(value));
        } else if (Float.TYPE.equals(type)) {
            field.setFloat(object, Float.parseFloat(value));
        } else {
            throw new ReflectionException("Failed writing field: " + value + " to class: " + type.getSimpleName() + " type " + type + " was unsupported");
        }
    }

    public T getObject() {
        return this.object;
    }
}

