/*
 * Decompiled with CFR 0.152.
 */
package grails.plugin.externalconfig;

import grails.plugin.externalconfig.WriteFilteringMap;
import grails.util.Environment;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.IntRange;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.IOGroovyMethods;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.StringGroovyMethods;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.grails.config.NavigableMapPropertySource;
import org.grails.config.PropertySourcesConfig;
import org.grails.config.yaml.YamlPropertySourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.SpringApplicationRunListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

public class ExternalConfigRunListener
implements SpringApplicationRunListener,
GroovyObject {
    private ResourceLoader defaultResourceLoader;
    private YamlPropertySourceLoader yamlPropertySourceLoader;
    private String userHome;
    private String separator;
    private final SpringApplication application;
    private static final transient Logger log;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;

    public ExternalConfigRunListener(SpringApplication application, String ... args) {
        SpringApplication springApplication;
        MetaClass metaClass;
        String string;
        String string2;
        YamlPropertySourceLoader yamlPropertySourceLoader;
        DefaultResourceLoader defaultResourceLoader = new DefaultResourceLoader();
        this.defaultResourceLoader = defaultResourceLoader;
        this.yamlPropertySourceLoader = yamlPropertySourceLoader = new YamlPropertySourceLoader();
        this.userHome = string2 = System.getProperties().getProperty("user.home");
        this.separator = string = System.getProperties().getProperty("file.separator");
        this.metaClass = metaClass = this.$getStaticMetaClass();
        this.application = springApplication = application;
    }

    public void environmentPrepared(ConfigurableEnvironment environment) {
        List<Object> locations = this.getLocations(environment);
        String encoding = ShortTypeHandling.castToString((Object)environment.getProperty("grails.config.encoding", String.class, (Object)"UTF-8"));
        Object location2 = null;
        for (Object location2 : locations) {
            MapPropertySource mapPropertySource;
            MapPropertySource propertySource = null;
            Map currentProperties = ExternalConfigRunListener.getCurrentConfig(environment);
            if (location2 instanceof Class) {
                MapPropertySource mapPropertySource2;
                propertySource = mapPropertySource2 = this.loadClassConfig((Class)ScriptBytecodeAdapter.asType((Object)location2, Class.class), currentProperties);
            } else {
                Object v0;
                String finalLocation = environment.resolvePlaceholders((String)ScriptBytecodeAdapter.asType((Object)location2, String.class));
                Resource resource = this.defaultResourceLoader.getResource(finalLocation);
                if (resource.exists()) {
                    if (finalLocation.endsWith(".groovy")) {
                        MapPropertySource mapPropertySource3;
                        propertySource = mapPropertySource3 = this.loadGroovyConfig(resource, encoding, currentProperties);
                    } else if (finalLocation.endsWith(".yml")) {
                        environment.getActiveProfiles();
                        NavigableMapPropertySource navigableMapPropertySource = this.loadYamlConfig(resource);
                        propertySource = navigableMapPropertySource;
                    } else {
                        MapPropertySource mapPropertySource4;
                        propertySource = mapPropertySource4 = this.loadPropertiesConfig(resource);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Config file {} not found", new Object[]{finalLocation});
                    v0 = null;
                } else {
                    v0 = null;
                }
            }
            if (!(DefaultTypeTransformation.booleanUnbox((mapPropertySource = propertySource) != null ? mapPropertySource.getSource() : null) && !((Map)propertySource.getSource()).isEmpty())) continue;
            environment.getPropertySources().addFirst((PropertySource)propertySource);
        }
        ExternalConfigRunListener.setMicronautConfigLocations(locations);
    }

    private List<Object> getLocations(ConfigurableEnvironment environment) {
        List locations = (List)environment.getProperty("grails.config.locations", List.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
        String environmentString = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{Environment.getCurrent().getName()}, new String[]{"environments.", ".grails.config.locations"}));
        Object object = environment.getProperty(environmentString, List.class, (Object)locations);
        locations = (List)ScriptBytecodeAdapter.castToType((Object)object, List.class);
        public final class _getLocations_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getLocations_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object location) {
                if (location instanceof CharSequence) {
                    String string = ((ExternalConfigRunListener)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExternalConfigRunListener.class)).replaceUserHomePrefix((String)ScriptBytecodeAdapter.asType((Object)location, String.class));
                    location = string;
                    List<Object> expandedLocations = ((ExternalConfigRunListener)ScriptBytecodeAdapter.castToType((Object)this.getThisObject(), ExternalConfigRunListener.class)).handleWildcardLocation((String)ScriptBytecodeAdapter.asType((Object)location, String.class));
                    if (DefaultTypeTransformation.booleanUnbox(expandedLocations)) {
                        return expandedLocations;
                    }
                }
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{location});
            }

            public Object call(Object location) {
                return this.doCall(location);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getLocations_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return DefaultGroovyMethods.collectMany((Iterable)locations, (Closure)new _getLocations_closure1(this, this));
    }

    private List<Object> handleWildcardLocation(String location) {
        block8: {
            if (location.startsWith("file:")) {
                String locationFileName = ShortTypeHandling.castToString((Object)DefaultGroovyMethods.getAt((List)StringGroovyMethods.tokenize((CharSequence)location, (CharSequence)this.separator), (int)-1));
                if (locationFileName.contains("*")) {
                    String parentLocation = StringGroovyMethods.minus((CharSequence)location, (Object)locationFileName);
                    Resource resource = this.defaultResourceLoader.getResource(parentLocation);
                    if (!(resource.getFile().exists() && resource.getFile().isDirectory())) break block8;
                    Path dir = resource.getFile().toPath();
                    DirectoryStream<Path> stream = Files.newDirectoryStream(dir, locationFileName);
                    public final class _handleWildcardLocation_closure2
                    extends Closure
                    implements GeneratedClosure {
                        private static /* synthetic */ ClassInfo $staticClassInfo;
                        public static transient /* synthetic */ boolean __$stMC;

                        public _handleWildcardLocation_closure2(Object _outerInstance, Object _thisObject) {
                            super(_outerInstance, _thisObject);
                        }

                        public Object doCall(Path p) {
                            return new GStringImpl(new Object[]{p.toAbsolutePath()}, new String[]{"file:", ""});
                        }

                        public Object call(Path p) {
                            return this.doCall(p);
                        }

                        protected /* synthetic */ MetaClass $getStaticMetaClass() {
                            if (((Object)((Object)this)).getClass() != _handleWildcardLocation_closure2.class) {
                                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                            }
                            ClassInfo classInfo = $staticClassInfo;
                            if (classInfo == null) {
                                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                            }
                            return classInfo.getMetaClass();
                        }
                    }
                    List list = DefaultGroovyMethods.collect(stream, (Closure)new _handleWildcardLocation_closure2(this, this));
                    try {
                        return list;
                    }
                    catch (FileNotFoundException ignore) {
                        List list2 = (List)ScriptBytecodeAdapter.castToType(null, List.class);
                        return list2;
                    }
                }
            }
        }
        return (List)ScriptBytecodeAdapter.castToType(null, List.class);
    }

    private String replaceUserHomePrefix(String location) {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.userHome) && location.startsWith("~/")) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{this.userHome, StringGroovyMethods.getAt((String)location, (IntRange)new IntRange(true, 1, Integer.valueOf(-1).intValue()))}, new String[]{"file:", "", ""});
            location = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        return location;
    }

    private MapPropertySource loadClassConfig(Class location, Map currentConfig) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading config class {}", (Object)location.getName());
            v0 = null;
        } else {
            v0 = null;
        }
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        WriteFilteringMap filterMap = new WriteFilteringMap(currentConfig);
        WriteFilteringMap writeFilteringMap = filterMap;
        slurper.setBinding((Map)writeFilteringMap);
        ConfigObject configObject = slurper.parse(location);
        Map properties = configObject != null ? configObject.flatten() : null;
        Map<String, Object> writtenValues = filterMap.getWrittenValues();
        properties.putAll(writtenValues);
        return new MapPropertySource(location.toString(), properties);
    }

    private MapPropertySource loadGroovyConfig(Resource resource, String encoding, Map currentConfig) {
        ConfigObject configObject;
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading groovy config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        String configText = IOGroovyMethods.getText((InputStream)resource.getInputStream(), (String)encoding);
        ConfigSlurper slurper = new ConfigSlurper(Environment.getCurrent().getName());
        WriteFilteringMap filterMap = new WriteFilteringMap(currentConfig);
        WriteFilteringMap writeFilteringMap = filterMap;
        slurper.setBinding((Map)writeFilteringMap);
        ConfigObject configObject2 = slurper.parse(configText);
        Map properties = DefaultTypeTransformation.booleanUnbox((Object)configText) ? ((configObject = configObject2) != null ? configObject.flatten() : null) : ScriptBytecodeAdapter.createMap((Object[])new Object[0]);
        Map<String, Object> writtenValues = filterMap.getWrittenValues();
        properties.putAll(writtenValues);
        return new MapPropertySource(resource.getFilename(), properties);
    }

    private NavigableMapPropertySource loadYamlConfig(Resource resource) {
        List list;
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading YAML config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        List yamlProperties = this.yamlPropertySourceLoader.load(resource.getFilename(), resource, null);
        NavigableMapPropertySource propertySource = (NavigableMapPropertySource)ScriptBytecodeAdapter.asType(DefaultTypeTransformation.booleanUnbox((Object)yamlProperties) ? ((list = yamlProperties) != null ? DefaultGroovyMethods.first((List)list) : null) : null, NavigableMapPropertySource.class);
        return propertySource;
    }

    private MapPropertySource loadPropertiesConfig(Resource resource) {
        Object v0;
        if (log.isInfoEnabled()) {
            log.info("Loading properties config file {}", (Object)resource.getURI());
            v0 = null;
        } else {
            v0 = null;
        }
        Properties properties = new Properties();
        properties.load(resource.getInputStream());
        return new MapPropertySource(resource.getFilename(), (Map)properties);
    }

    private static void setMicronautConfigLocations(List<Object> newSources) {
        Object v0;
        List sources = StringGroovyMethods.tokenize((CharSequence)System.getProperty("micronaut.config.files", ""), (CharSequence)",");
        public final class _setMicronautConfigLocations_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _setMicronautConfigLocations_closure3(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return DefaultGroovyMethods.toString((Object)it);
            }

            public Object call(Object args) {
                return this.doCall(args);
            }

            public Object call() {
                return this.doCall(null);
            }

            @Generated
            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setMicronautConfigLocations_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        sources.addAll(DefaultGroovyMethods.collect(newSources, (Closure)new _setMicronautConfigLocations_closure3(ExternalConfigRunListener.class, ExternalConfigRunListener.class)));
        if (log.isDebugEnabled()) {
            log.debug(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DefaultGroovyMethods.join((Iterable)sources, (String)",")}, new String[]{"---> Setting 'micronaut.config.files' to ", ""})));
            v0 = null;
        } else {
            v0 = null;
        }
        System.setProperty("micronaut.config.files", DefaultGroovyMethods.join((Iterable)sources, (String)","));
    }

    public void starting() {
    }

    public void started() {
    }

    public void contextPrepared(ConfigurableApplicationContext context) {
    }

    public void contextLoaded(ConfigurableApplicationContext context) {
    }

    public void started(ConfigurableApplicationContext context) {
    }

    public void running(ConfigurableApplicationContext context) {
    }

    public void failed(ConfigurableApplicationContext context, Throwable exception) {
    }

    public void finished(ConfigurableApplicationContext context, Throwable exception) {
    }

    public static Map getCurrentConfig(ConfigurableEnvironment environment) {
        return new PropertySourcesConfig((PropertySources)environment.getPropertySources());
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ExternalConfigRunListener.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    static {
        Logger logger;
        log = logger = LoggerFactory.getLogger((String)"grails.plugin.externalconfig.ExternalConfig");
    }

    @Generated
    public final SpringApplication getApplication() {
        return this.application;
    }
}

