/*
 * Decompiled with CFR 0.152.
 */
package dk.kosmisk.postgresql.it;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.nio.file.Path;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.dbcp2.ConnectionFactory;
import org.apache.commons.dbcp2.DriverManagerConnectionFactory;
import org.apache.commons.dbcp2.PoolableConnection;
import org.apache.commons.dbcp2.PoolableConnectionFactory;
import org.apache.commons.dbcp2.PoolingDataSource;
import org.apache.commons.pool2.ObjectPool;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class PostgresITDataSource
extends PoolingDataSource<PoolableConnection> {
    private static final String DRIVER = "org.postgresql.Driver";
    private static final String ALL_TABLES = "SELECT tablename FROM pg_tables WHERE schemaname='public'";
    private static final String FOREIGN_KEY = "SELECT ft.relname, tt.relname FROM pg_constraint AS c JOIN pg_namespace AS n ON c.connamespace = n.oid JOIN pg_class AS ft ON c.conrelid = ft.oid JOIN pg_class AS tt ON c.confrelid = tt.oid WHERE n.nspname = 'public' AND c.contype = 'f'";
    private static DatabaseLocation DATABASE_FALLBACK = props -> {
        Map<String, String> env = System.getenv();
        String userName = System.getProperty("user.name");
        String user = env.getOrDefault("PGUSER", userName);
        String pass = env.getOrDefault("PGPASSWORD", userName);
        String host = env.getOrDefault("PGHOST", "localhost");
        String port = env.getOrDefault("PGPORT", "5432");
        String base = env.getOrDefault("PGDATABASE", userName);
        if (user != null) {
            props.setProperty("user", user);
        }
        if (pass != null) {
            props.setProperty("password", pass);
        }
        return "jdbc:postgresql://" + host + ":" + port + "/" + base;
    };

    public PostgresITDataSource(List<DatabaseLocation> locations, boolean useFallback) {
        super(PostgresITDataSource.makeConnectionPool(locations, useFallback));
    }

    public PostgresITDataSource(DatabaseLocation location) {
        this(Arrays.asList(location), true);
    }

    public PostgresITDataSource(String databaseName, String portPropertyName) {
        this(Arrays.asList(new DatabaseFromProperty(databaseName, portPropertyName)), true);
    }

    public PostgresITDataSource(String databaseName) {
        this(Arrays.asList(new DatabaseFromProperty(databaseName)), true);
    }

    private static Connection setLogging(Connection connection) throws SQLException {
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate("SET log_statement = 'all'");
        }
        return connection;
    }

    public Connection getConnection() throws SQLException {
        return PostgresITDataSource.setLogging(super.getConnection());
    }

    public Connection getConnection(String user, String password) throws SQLException {
        return PostgresITDataSource.setLogging(super.getConnection(user, password));
    }

    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    public void truncateTables(Collection<String> tables) throws SQLException {
        try (Connection connection = super.getConnection();
             Statement stmt = connection.createStatement();){
            connection.setAutoCommit(false);
            for (String table : tables) {
                table = table.replaceAll("[^0-9_a-zA-Z]", "");
                stmt.execute("TRUNCATE " + table + " CASCADE");
            }
            connection.commit();
        }
    }

    public void truncateTables(String ... tables) throws SQLException {
        this.truncateTables(Arrays.asList(tables));
    }

    public void truncateAllTables() throws SQLException {
        this.truncateTables(this.allTableNames());
    }

    public void wipe() throws SQLException {
        try (Connection connection = super.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.executeUpdate("DROP SCHEMA IF EXISTS public CASCADE");
            stmt.executeUpdate("CREATE SCHEMA public");
        }
    }

    public List<String> allTableNames() throws SQLException {
        HashMap foreignKeysRules = new HashMap();
        try (Connection connection = super.getConnection();
             Statement tablesStmt = connection.createStatement();
             Statement foreignKeysStmt = connection.createStatement();
             ResultSet tables = tablesStmt.executeQuery(ALL_TABLES);
             ResultSet foreignKeys = foreignKeysStmt.executeQuery(FOREIGN_KEY);){
            while (tables.next()) {
                foreignKeysRules.put(tables.getString(1), new HashSet());
            }
            while (foreignKeys.next()) {
                ((HashSet)foreignKeysRules.get(foreignKeys.getString(1))).add(foreignKeys.getString(2));
            }
        }
        ArrayList<String> orderedTables = new ArrayList<String>(foreignKeysRules.size());
        while (!foreignKeysRules.isEmpty()) {
            Set tables = foreignKeysRules.entrySet().stream().filter(e -> ((HashSet)e.getValue()).isEmpty()).map(e -> (String)e.getKey()).collect(Collectors.toSet());
            if (tables.isEmpty()) {
                throw new IllegalStateException("Tables have mutual foreign key. No order can be determined for: " + String.join((CharSequence)", ", foreignKeysRules.keySet()));
            }
            foreignKeysRules.keySet().removeAll(tables);
            foreignKeysRules.values().stream().forEach(set -> set.removeAll(tables));
            orderedTables.addAll(tables);
        }
        return orderedTables;
    }

    public void copyTablesToDisk(Collection<String> tables) throws SQLException {
        this.copyData(tables, "TO");
    }

    public void copyTablesToDisk(String ... tables) throws SQLException {
        this.copyTablesToDisk(Arrays.asList(tables));
    }

    public void copyAllTablesToDisk() throws SQLException {
        this.copyTablesToDisk(this.allTableNames());
    }

    public void copyTablesFromDisk(Collection<String> tables) throws SQLException {
        this.copyData(tables, "FROM");
    }

    public void copyTablesFromDisk(String ... tables) throws SQLException {
        this.copyTablesFromDisk(Arrays.asList(tables));
    }

    public void copyAllTablesFromDisk() throws SQLException {
        this.copyTablesFromDisk(this.allTableNames());
    }

    @SuppressFBWarnings(value={"SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE"})
    private void copyData(Collection<String> tables, String direction) throws SQLException {
        String dumpFolderLocation = System.getProperty("postgresql.dump.folder");
        if (dumpFolderLocation == null && (dumpFolderLocation = System.getProperty("java.io.tmpdir")) != null) {
            File tempDirFile = new File(dumpFolderLocation).toPath().resolve("pg_dumps").toFile();
            if (!tempDirFile.isDirectory() && !tempDirFile.mkdirs()) {
                throw new RuntimeException("Could not make temp dir for postgres dumps: " + tempDirFile.toString());
            }
            dumpFolderLocation = tempDirFile.toString();
        }
        if (dumpFolderLocation == null) {
            throw new RuntimeException("Cannot find temp location for postgres dumps");
        }
        Path tempPath = new File(dumpFolderLocation).toPath();
        try (Connection connection = super.getConnection();
             Statement stmt = connection.createStatement();){
            for (String table : tables) {
                table = table.replaceAll("[^0-9_a-zA-Z]", "");
                StringBuilder sql = new StringBuilder();
                sql.append("COPY ").append(table).append(" ").append(direction).append(" '").append(tempPath.resolve(table + ".dat").toString().replaceAll("'", "''")).append("'");
                stmt.executeUpdate(sql.toString());
            }
        }
    }

    private static ObjectPool<PoolableConnection> makeConnectionPool(List<DatabaseLocation> locations, boolean useFallback) {
        DatabaseLocation location;
        String connectString = null;
        Properties props = new Properties();
        Iterator<DatabaseLocation> iterator = locations.iterator();
        while (iterator.hasNext() && (connectString = (location = iterator.next()).jdbcUrl(props)) == null) {
        }
        if (connectString == null && useFallback) {
            connectString = DATABASE_FALLBACK.jdbcUrl(props);
        }
        if (connectString == null) {
            throw new IllegalStateException("Cannot locate database");
        }
        return PostgresITDataSource.constructConnectionPool(connectString, props);
    }

    private static ObjectPool<PoolableConnection> constructConnectionPool(String connectString, Properties props) {
        try {
            PostgresITDataSource.class.getClassLoader().loadClass(DRIVER);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Cannot load driver: org.postgresql.Driver", ex);
        }
        DriverManagerConnectionFactory factory = new DriverManagerConnectionFactory(connectString, props);
        PoolableConnectionFactory pool = new PoolableConnectionFactory((ConnectionFactory)factory, null);
        GenericObjectPool connectionPool = new GenericObjectPool((PooledObjectFactory)pool);
        pool.setPool((ObjectPool)connectionPool);
        return connectionPool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class DatabaseFromEnvironment
    implements DatabaseLocation {
        private static final Pattern POSTGRES_URL_REGEX = Pattern.compile("(?:postgres(?:ql)?://)?(?:([^:@]+)(?::([^@]*))@)?([^:/]+)(?::([1-9][0-9]*))?/(.+)");
        private final String environmentName;

        public DatabaseFromEnvironment(String environmentName) {
            this.environmentName = environmentName;
        }

        @Override
        public String jdbcUrl(Properties props) {
            String url = System.getenv(this.environmentName);
            if (url == null) {
                return null;
            }
            Matcher matcher = POSTGRES_URL_REGEX.matcher(url);
            if (matcher.matches()) {
                String user = matcher.group(1);
                String pass = matcher.group(2);
                String host = matcher.group(3);
                String port = matcher.group(4);
                String base = matcher.group(5);
                if (user != null) {
                    props.setProperty("user", user);
                }
                if (pass != null) {
                    props.setProperty("password", pass);
                }
                if (port == null) {
                    port = "5432";
                }
                return "jdbc:postgresql://" + host + ":" + port + "/" + base;
            }
            System.out.println("noMatch");
            System.err.println("Cannot match environment url: " + url + " - falling back");
            return null;
        }
    }

    public static class DatabaseFromProperty
    implements DatabaseLocation {
        private final String portProperty;
        private final String databaseName;

        public DatabaseFromProperty(String databaseName, String portProperty) {
            this.portProperty = portProperty;
            this.databaseName = databaseName;
        }

        public DatabaseFromProperty(String databaseName) {
            this(databaseName, "postgresql." + databaseName + ".port");
        }

        @Override
        public String jdbcUrl(Properties props) {
            String propertyPort = System.getProperty(this.portProperty);
            if (propertyPort == null) {
                return null;
            }
            String userName = System.getProperty("user.name");
            props.setProperty("user", userName);
            props.setProperty("password", userName);
            return "jdbc:postgresql://localhost:" + propertyPort + "/" + this.databaseName;
        }
    }

    public static interface DatabaseLocation {
        public String jdbcUrl(Properties var1);
    }

    public static final class Builder {
        private final List<DatabaseLocation> locations = new ArrayList<DatabaseLocation>();
        private Boolean useFallback = null;

        public Builder fromProperty(String databaseName, String portPropertyName) {
            this.locations.add(new DatabaseFromProperty(databaseName, portPropertyName));
            return this;
        }

        public Builder fromProperty(String databaseName) {
            this.locations.add(new DatabaseFromProperty(databaseName));
            return this;
        }

        public Builder fromEnvironment(String environmentName) {
            this.locations.add(new DatabaseFromEnvironment(environmentName));
            return this;
        }

        public Builder withoutFallback() {
            this.useFallback = this.setOrFail(this.useFallback, false, "withoutFallback");
            return this;
        }

        public Builder withFallback() {
            this.useFallback = this.setOrFail(this.useFallback, true, "withFallback");
            return this;
        }

        public PostgresITDataSource build() {
            return new PostgresITDataSource(this.locations, this.or(null, this.useFallback, true));
        }

        private <T> T setOrFail(T oldValue, T newValue, String name) {
            if (oldValue != null) {
                throw new IllegalArgumentException("Cannot set " + name + " to: " + newValue + " has already been set to: " + oldValue);
            }
            return newValue;
        }

        @SafeVarargs
        private final <T> T or(String name, T ... ts) {
            for (T t : ts) {
                if (t == null) continue;
                return t;
            }
            throw new IllegalArgumentException("Required value has not been set " + name);
        }
    }
}

