/*
 * Decompiled with CFR 0.152.
 */
package dk.mada.style.configurators;

import dk.mada.style.config.ConfigFileExtractor;
import dk.mada.style.config.PluginConfiguration;
import java.nio.file.Path;
import java.util.Objects;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.tasks.TaskContainer;

public class CheckstyleConfigurator {
    private static final String CHECKSTYLE_CHECKSTYLE_MADA_XML = "checkstyle/checkstyle-mada.xml";
    private static final String CHECKSTYLE_SUPPRESSIONS_MADA_XML = "checkstyle/suppressions-mada.xml";
    private final Project project;
    private final Logger logger;
    private final PluginConfiguration.CheckstyleConfiguration checkstyleConfig;
    private final Path defaultConfigFile;
    private final ConfigFileExtractor configExtractor;

    public CheckstyleConfigurator(Project project, PluginConfiguration.CheckstyleConfiguration checkstyleConfig, ConfigFileExtractor configExtractor) {
        this.logger = project.getLogger();
        this.project = project;
        this.checkstyleConfig = checkstyleConfig;
        this.configExtractor = configExtractor;
        this.defaultConfigFile = configExtractor.getLocalConfigFileFromResource(CHECKSTYLE_CHECKSTYLE_MADA_XML);
        configExtractor.getLocalConfigFileFromResource(CHECKSTYLE_SUPPRESSIONS_MADA_XML);
    }

    public void configure(CheckstyleExtension ce) {
        Path shippedConfigDir = Objects.requireNonNull(this.defaultConfigFile.getParent());
        ce.getConfigDirectory().convention(this.toGradleDir(shippedConfigDir));
        Path activeConfigfile = this.getActiveConfigfile();
        this.logger.info("Checkstyle config {}", (Object)activeConfigfile);
        ce.setIgnoreFailures(this.checkstyleConfig.ignoreFailures());
        ce.setConfigFile(activeConfigfile.toFile());
        String toolVersion = this.checkstyleConfig.toolVersion();
        if (toolVersion != null) {
            ce.setToolVersion(toolVersion);
        }
        TaskContainer taskContainer = this.project.getTasks();
        if (this.checkstyleConfig.ignoreTestSource()) {
            taskContainer.named("checkstyleTest", this::disableTask);
        }
        taskContainer.withType(Checkstyle.class, t -> {
            if (this.checkstyleConfig.ignoreGeneratedSource() && t.getName().endsWith("Apt")) {
                this.disableTask((Task)t);
            } else {
                t.setExcludes(this.checkstyleConfig.excludes());
                t.setIncludes(this.checkstyleConfig.includes());
            }
        });
    }

    private Directory toGradleDir(Path dir) {
        return this.project.getLayout().getProjectDirectory().dir(dir.toAbsolutePath().toString());
    }

    private void disableTask(Task t) {
        t.setOnlyIf("disabled by mada style", ta -> false);
    }

    private Path getActiveConfigfile() {
        String configPath = this.checkstyleConfig.configPath();
        if (configPath != null) {
            return this.configExtractor.getLocalFileFromConfigPath(configPath);
        }
        return this.defaultConfigFile;
    }
}

