/*
 * Decompiled with CFR 0.152.
 */
package dk.mada.style.configurators;

import dk.mada.style.config.PluginConfiguration;
import dk.mada.style.config.ResourceConfigProperties;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.ltgt.gradle.errorprone.CheckSeverity;
import net.ltgt.gradle.errorprone.ErrorProneOptions;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.compile.JavaCompile;

public class ErrorProneConfigurator {
    private static final String CONFIG_DATAFILE_DEPENDENCIES_PROPERTIES = "/config/datafile-dependencies.properties";
    private final Project project;
    private final Logger logger;
    private final PluginConfiguration.ErrorProneConfiguration errorProneConfig;
    private final PluginConfiguration.NullcheckerConfiguration nullcheckerConfig;
    private final Properties dependencyVersions;

    public ErrorProneConfigurator(Project project, PluginConfiguration.ErrorProneConfiguration errorProneConfig, PluginConfiguration.NullcheckerConfiguration nullcheckerConfig) {
        this.project = project;
        this.logger = project.getLogger();
        this.errorProneConfig = errorProneConfig;
        this.nullcheckerConfig = nullcheckerConfig;
        this.dependencyVersions = ResourceConfigProperties.readConfigProperties(CONFIG_DATAFILE_DEPENDENCIES_PROPERTIES);
    }

    public void configure() {
        this.logger.info("dk.mada.style configure errorprone");
        this.addDependency("com.google.errorprone:error_prone_core");
        if (this.nullcheckerConfig.enabled()) {
            this.addDependency("com.uber.nullaway:nullaway");
        }
        this.project.getTasks().withType(JavaCompile.class, jc -> {
            ErrorProneOptions er = (ErrorProneOptions)((ExtensionAware)jc.getOptions()).getExtensions().getByType(ErrorProneOptions.class);
            boolean isTestCodeCompileTask = jc.getName().toLowerCase(Locale.ROOT).contains("test");
            if (isTestCodeCompileTask && this.errorProneConfig.ignoreTestSource()) {
                er.getEnabled().set((Object)false);
            } else {
                this.configureErrorProne(er);
            }
        });
    }

    private void configureErrorProne(ErrorProneOptions er) {
        ErrorProneConfigurator.makeList(this.errorProneConfig.disabledRules()).forEach(ruleName -> er.check(ruleName, CheckSeverity.OFF));
        er.getExcludedPaths().set((Object)this.errorProneConfig.excludePathsRegexp());
        er.getDisableWarningsInGeneratedCode().set((Object)this.errorProneConfig.ignoreGeneratedSource());
        if (this.nullcheckerConfig.enabled()) {
            er.check("NullAway", CheckSeverity.ERROR);
            er.option("NullAway:AnnotatedPackages", ErrorProneConfigurator.makeValidNoSpaceString(this.nullcheckerConfig.includePackages()));
            er.option("NullAway:UnannotatedSubPackages", ErrorProneConfigurator.makeValidNoSpaceString(this.nullcheckerConfig.excludePackages()));
            er.option("NullAway:ExcludedFieldAnnotations", ErrorProneConfigurator.makeValidNoSpaceString(this.nullcheckerConfig.excludedFieldAnnotations()));
        }
    }

    private void addDependency(String groupArtifact) {
        String version = this.dependencyVersions.getProperty(groupArtifact);
        String gav = groupArtifact + ":" + Objects.requireNonNull(version, "Did not find version for dependency '" + groupArtifact + "'");
        this.project.getDependencies().add("errorprone", (Object)gav);
    }

    private static String makeValidNoSpaceString(String s) {
        return Stream.of(s.split(",", -1)).map(String::trim).collect(Collectors.joining(","));
    }

    private static List<String> makeList(String s) {
        return Stream.of(s.split(",", -1)).map(String::trim).toList();
    }
}

