/*
 * Decompiled with CFR 0.152.
 */
package dk.mada.style.configurators;

import dk.mada.style.config.PluginConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;
import org.gradle.testing.jacoco.tasks.JacocoReport;
import org.sonarqube.gradle.SonarExtension;
import org.sonarqube.gradle.SonarProperties;
import org.sonarqube.gradle.SonarTask;

public class SonarConfigurator {
    private final Project project;
    private final Logger logger;
    private final PluginConfiguration.SonarConfiguration sonarConfig;

    public SonarConfigurator(Project project, PluginConfiguration.SonarConfiguration sonarConfig) {
        this.project = project;
        this.logger = project.getLogger();
        this.sonarConfig = sonarConfig;
    }

    public void configure(SonarExtension se) {
        this.logger.info("dk.mada.style configure sonar");
        TaskContainer taskContainer = this.project.getTasks();
        PluginContainer plugins = this.project.getPlugins();
        taskContainer.withType(SonarTask.class, sonarTask -> {
            plugins.withType(CheckstylePlugin.class).whenPluginAdded(p -> taskContainer.withType(Checkstyle.class, xva$0 -> sonarTask.dependsOn(new Object[]{xva$0})));
            plugins.withType(JacocoPlugin.class).whenPluginAdded(p -> taskContainer.withType(JacocoReport.class, xva$0 -> sonarTask.dependsOn(new Object[]{xva$0})));
        });
        Map<String, String> inputProps = this.project.getProperties().entrySet().stream().filter(e -> !((String)e.getKey()).equals("dk.mada.style.sonar.enabled")).filter(e -> ((String)e.getKey()).startsWith("dk.mada.style.sonar.")).collect(Collectors.toMap(e -> ((String)e.getKey()).replace("dk.mada.style.", ""), e -> Objects.toString(e.getValue())));
        HashMap<String, String> combinedMadaSonarProps = new HashMap<String, String>();
        combinedMadaSonarProps.putAll(this.sonarConfig.madaConventionProperties());
        combinedMadaSonarProps.putAll(inputProps);
        this.logger.info("Set sonar properties: {}", combinedMadaSonarProps);
        se.properties(sp -> combinedMadaSonarProps.forEach((arg_0, arg_1) -> ((SonarProperties)sp).property(arg_0, arg_1)));
    }
}

