/*
 * Decompiled with CFR 0.152.
 */
package dk.mada.style.configurators;

import com.diffplug.gradle.spotless.JavaExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import dk.mada.style.config.ConfigFileExtractor;
import dk.mada.style.config.PluginConfiguration;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.gradle.api.logging.Logger;

public class SpotlessConfigurator {
    private static final String SPOTLESS_ECLIPSE_FORMATTER_MADA_XML = "spotless/eclipse-formatter-mada.xml";
    private final Logger logger;
    private final PluginConfiguration.FormatterConfiguration formatterConfig;
    private final Path defaultConfigFile;
    private final ConfigFileExtractor configExtractor;

    public SpotlessConfigurator(Logger logger, PluginConfiguration.FormatterConfiguration formatterConfig, ConfigFileExtractor configExtractor) {
        this.logger = logger;
        this.formatterConfig = formatterConfig;
        this.configExtractor = configExtractor;
        this.defaultConfigFile = configExtractor.getLocalConfigFileFromResource(SPOTLESS_ECLIPSE_FORMATTER_MADA_XML);
    }

    public void configure(SpotlessExtension se) {
        this.logger.info("dk.mada.style configure spotless");
        se.java(this::configureJava);
    }

    private void configureJava(JavaExtension je) {
        List<String> include = this.formatterConfig.includes();
        List<String> exclude = this.formatterConfig.excludes();
        Path configFile = this.getActiveConfigfile();
        this.logger.debug("Spotless java config: {}", (Object)configFile);
        this.logger.debug("Spotless java include:{} exclude:{}", include, exclude);
        je.target(new Object[]{include});
        je.targetExclude(new Object[]{exclude});
        JavaExtension.EclipseConfig eclipseConfig = je.eclipse();
        eclipseConfig.configFile(new Object[]{configFile});
        String p2Mirror = this.formatterConfig.eclipse432P2mirror();
        if (p2Mirror != null) {
            eclipseConfig.withP2Mirrors(Map.of("https://download.eclipse.org/eclipse/updates/4.32/", p2Mirror));
        }
        je.formatAnnotations();
    }

    private Path getActiveConfigfile() {
        String configPath = this.formatterConfig.eclipseConfigPath();
        if (configPath != null) {
            return this.configExtractor.getLocalFileFromConfigPath(configPath);
        }
        return this.defaultConfigFile;
    }
}

