/*
 * Decompiled with CFR 0.152.
 */
package dk.mada.style;

import com.diffplug.gradle.spotless.SpotlessExtension;
import com.diffplug.gradle.spotless.SpotlessPlugin;
import dk.mada.style.config.ConfigFileExtractor;
import dk.mada.style.config.PluginConfiguration;
import dk.mada.style.configurators.CheckstyleConfigurator;
import dk.mada.style.configurators.ErrorProneConfigurator;
import dk.mada.style.configurators.SonarConfigurator;
import dk.mada.style.configurators.SpotlessConfigurator;
import net.ltgt.gradle.errorprone.ErrorPronePlugin;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.Logger;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CheckstylePlugin;
import org.sonarqube.gradle.SonarExtension;
import org.sonarqube.gradle.SonarQubePlugin;

public final class MadaStylePlugin
implements Plugin<Project> {
    void foo() {
    }

    public void apply(Project project) {
        project.getPlugins().withType(JavaPlugin.class, jp -> this.applyPlugins(project));
    }

    private void applyPlugins(Project project) {
        Logger logger = project.getLogger();
        logger.info("Applying mada.style plugin");
        PluginConfiguration configuration = new PluginConfiguration(project);
        ConfigFileExtractor configExtractor = new ConfigFileExtractor(logger, project.getGradle().getGradleHomeDir().toPath());
        if (configuration.isCheckstyleActive()) {
            project.getPluginManager().apply("checkstyle");
            project.getPlugins().withType(CheckstylePlugin.class, cp -> this.lazyConfigureCheckstyle(project, configuration, configExtractor));
        }
        if (configuration.isFormatterActive()) {
            project.getPluginManager().apply("com.diffplug.spotless");
            project.getPlugins().withType(SpotlessPlugin.class, sp -> this.lazyConfigureFormatter(project, configuration));
        }
        if (configuration.isNullcheckerActive() || configuration.isErrorProneActive()) {
            project.getPluginManager().apply("net.ltgt.errorprone");
            project.getPlugins().withType(ErrorPronePlugin.class, ep -> new ErrorProneConfigurator(project, configuration.errorProne(), configuration.nullchecker()).configure());
        }
        if (configuration.isSonarActive()) {
            System.setProperty("sonar.gradle.skipCompile", "true");
            project.getPluginManager().apply("org.sonarqube");
            project.getPlugins().withType(SonarQubePlugin.class, sp -> this.lazyConfigureSonar(project, configuration));
        }
    }

    private void lazyConfigureCheckstyle(Project project, PluginConfiguration configuration, ConfigFileExtractor configExtractor) {
        project.getExtensions().configure(CheckstyleExtension.class, ce -> new CheckstyleConfigurator(project, configuration.checkstyle(), configExtractor).configure((CheckstyleExtension)ce));
    }

    private void lazyConfigureFormatter(Project project, PluginConfiguration configuration) {
        project.getExtensions().configure(SpotlessExtension.class, se -> new SpotlessConfigurator(project.getLogger(), configuration.formatter()).configure((SpotlessExtension)se));
    }

    private void lazyConfigureSonar(Project project, PluginConfiguration configuration) {
        project.getExtensions().configure(SonarExtension.class, se -> new SonarConfigurator(project, configuration.sonar()).configure((SonarExtension)se));
    }
}

