/*
 * Decompiled with CFR 0.152.
 */
package dk.mada.style.config;

import dk.mada.style.config.ResourceConfigProperties;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.HexFormat;
import java.util.Properties;
import java.util.function.Supplier;
import org.gradle.api.logging.Logger;

public final class ConfigFileExtractor {
    private final Logger logger;
    private static final Duration DOWNLOAD_CONNECT_TIMEOUT = Duration.ofSeconds(20L);
    private static final String CHECKSUMS_PROPERTIES = "/config/datafile-checksums.properties";
    private final Path gradleHomeDir;
    private final Properties dataChecksums;

    public ConfigFileExtractor(Logger logger, Path gradleHomeDir) {
        this.logger = logger;
        this.gradleHomeDir = gradleHomeDir;
        this.dataChecksums = ResourceConfigProperties.readConfigProperties(CHECKSUMS_PROPERTIES);
    }

    public Path getLocalConfigFileFromResource(String path) {
        String checksum = this.dataChecksums.getProperty(path);
        if (checksum == null) {
            throw new IllegalStateException("Failed to read " + path + " from data checksums: " + String.valueOf(this.dataChecksums));
        }
        String resourcePath = "/config/" + path;
        return this.lazyGetLocalFile(resourcePath, checksum, () -> this.readClassloaderResource(resourcePath));
    }

    public Path getLocalFileFromConfigPath(String path) {
        if (path.startsWith("http://") || path.startsWith("https://")) {
            String safePath = path.replaceAll("[^a-zA-Z0-9.-]", "_");
            return this.lazyGetLocalFile(safePath, this.checksum(path), () -> this.fetchUrlContent(path));
        }
        Path f = Paths.get(path, new String[0]);
        if (Files.isRegularFile(f, new LinkOption[0])) {
            return f;
        }
        throw new IllegalArgumentException("Provided path '" + path + "' is not a file");
    }

    private Path lazyGetLocalFile(String path, String checksum, Supplier<String> supplier) {
        Path madaConfigDir = this.gradleHomeDir.resolve("mada-data");
        try {
            int nameIndex = path.lastIndexOf(47);
            String dirname = path.substring(0, nameIndex);
            if (dirname.startsWith("/")) {
                dirname = dirname.substring(1);
            }
            String filename = path.substring(nameIndex + 1);
            Path configDir = madaConfigDir.resolve(dirname).resolve(checksum);
            Path targetFile = configDir.resolve(filename);
            Path markerFile = configDir.resolve(filename + ".valid");
            if (Files.exists(markerFile, new LinkOption[0])) {
                this.logger.debug("Already have config file {} : {}", (Object)path, (Object)targetFile);
                return targetFile;
            }
            this.logger.debug("Missing config file {}, fetching...", (Object)path);
            Files.createDirectories(configDir, new FileAttribute[0]);
            Files.deleteIfExists(targetFile);
            Files.writeString(targetFile, (CharSequence)supplier.get(), new OpenOption[0]);
            Files.createFile(markerFile, new FileAttribute[0]);
            return targetFile;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to save " + path + " in " + String.valueOf(madaConfigDir), e);
        }
    }

    private String readClassloaderResource(String resourcePath) {
        String string;
        block9: {
            InputStream is = this.getClass().getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    throw new IllegalStateException("Failed to read config file " + resourcePath);
                }
                string = new String(is.readAllBytes(), StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to read resource " + resourcePath, e);
                }
            }
            is.close();
        }
        return string;
    }

    private String fetchUrlContent(String url) {
        try {
            this.logger.debug("Download data from {}", (Object)url);
            HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(DOWNLOAD_CONNECT_TIMEOUT).build();
            HttpRequest request = HttpRequest.newBuilder().GET().uri(URI.create(url)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            return response.body();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interruped while fetching remote file " + url, e);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to fetch remote file " + url, e);
        }
    }

    private String checksum(String s) {
        try {
            byte[] d = MessageDigest.getInstance("SHA-256").digest(s.getBytes(StandardCharsets.UTF_8));
            return HexFormat.of().formatHex(d);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Failed to make checksum", e);
        }
    }
}

