/*
 * Decompiled with CFR 0.152.
 */
package dk.mada.style.config;

import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.gradle.api.Project;
import org.jspecify.annotations.Nullable;

public class PluginConfiguration {
    private static final String DK_MADA_STYLE_PROPPREFIX = "dk.mada.style.";
    private final Project project;
    private final CheckstyleConfiguration checkstyleConf;
    private final ErrorProneConfiguration errorproneConf;
    private final FormatterConfiguration formatterConf;
    private final NullcheckerConfiguration nullcheckerConf;
    private final SonarConfiguration sonarConf;

    public PluginConfiguration(Project project) {
        this.project = project;
        this.checkstyleConf = new CheckstyleConfiguration(this.getBoolProperty("checkstyle.enabled", true), this.getListProperty("checkstyle.includes", List.of()), this.getListProperty("checkstyle.excludes", List.of()), this.getBoolProperty("checkstyle.ignore-failures", true), this.getBoolProperty("checkstyle.ignore-test-source", false), this.getBoolProperty("checkstyle.ignore-generated-source", false), this.getNullableProperty("checkstyle.tool-version", null), this.getNullableProperty("checkstyle.config-path", null));
        this.errorproneConf = new ErrorProneConfiguration(this.getBoolProperty("errorprone.enabled", true), this.getBoolProperty("errorprone.ignore-test-source", false), this.getBoolProperty("errorprone.ignore-generated-source", false), this.getProperty("errorprone.excluded-paths-regexp", ""), this.getProperty("errorprone.disabled-rules", "ImmutableEnumChecker,JavaTimeDefaultTimeZone"));
        @Nullable String oldEclipseP2UrlConfig = this.getNullableProperty("formatter.eclipse-432-p2-url", null);
        if (oldEclipseP2UrlConfig != null) {
            throw new IllegalArgumentException("You should specify formatter.eclipse-434-p2-url instead!");
        }
        this.formatterConf = new FormatterConfiguration(this.getBoolProperty("formatter.enabled", true), this.getListProperty("formatter.include", List.of("src/main/java/**/*.java", "src/test/java/**/*.java")), this.getListProperty("formatter.exclude", List.of()));
        this.nullcheckerConf = new NullcheckerConfiguration(this.getBoolProperty("null-checker.enabled", true), this.getProperty("null-checker.include-packages", "dk"), this.getProperty("null-checker.exclude-packages", ""), this.getProperty("null-checker.exclude-field-annotations", "javafx.fxml.FXML, org.junit.jupiter.api.io.TempDir"));
        this.sonarConf = new SonarConfiguration(this.getBoolProperty("sonar.enabled", true), Map.of("sonar.host.url", "https://sonarcloud.io", "sonar.sourceEncoding", "UTF-8"));
    }

    public CheckstyleConfiguration checkstyle() {
        return this.checkstyleConf;
    }

    public boolean isCheckstyleActive() {
        return this.checkstyle().enabled();
    }

    public ErrorProneConfiguration errorProne() {
        return this.errorproneConf;
    }

    public boolean isErrorProneActive() {
        return this.errorProne().enabled();
    }

    public FormatterConfiguration formatter() {
        return this.formatterConf;
    }

    public boolean isFormatterActive() {
        return this.formatter().enabled();
    }

    public NullcheckerConfiguration nullchecker() {
        return this.nullcheckerConf;
    }

    public boolean isNullcheckerActive() {
        return this.nullchecker().enabled();
    }

    public SonarConfiguration sonar() {
        return this.sonarConf;
    }

    public boolean isSonarActive() {
        return this.sonar().enabled();
    }

    private boolean getBoolProperty(String name, boolean defaultValue) {
        String value = this.getNullableProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    private String getProperty(String name, String defaultValue) {
        String value = this.getNullableProperty(name, defaultValue);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private @Nullable String getNullableProperty(String name, @Nullable String defaultValue) {
        Object value = this.project.findProperty(DK_MADA_STYLE_PROPPREFIX + name);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    private List<String> getListProperty(String name, List<String> defaultValue) {
        String value = this.getNullableProperty(name, null);
        if (value == null) {
            return defaultValue;
        }
        return Stream.of(value.split(",", -1)).map(String::trim).toList();
    }

    public record CheckstyleConfiguration(boolean enabled, List<String> includes, List<String> excludes, boolean ignoreFailures, boolean ignoreTestSource, boolean ignoreGeneratedSource, @Nullable String toolVersion, @Nullable String configPath) {
    }

    public record ErrorProneConfiguration(boolean enabled, boolean ignoreTestSource, boolean ignoreGeneratedSource, String excludePathsRegexp, String disabledRules) {
    }

    public record FormatterConfiguration(boolean enabled, List<String> includes, List<String> excludes) {
    }

    public record NullcheckerConfiguration(boolean enabled, String includePackages, String excludePackages, String excludedFieldAnnotations) {
    }

    public record SonarConfiguration(boolean enabled, Map<String, String> madaConventionProperties) {
    }
}

