/*
 * Decompiled with CFR 0.152.
 */
package dk.mada.style.configurators;

import com.diffplug.gradle.spotless.JavaExtension;
import com.diffplug.gradle.spotless.SpotlessExtension;
import dk.mada.style.config.PluginConfiguration;
import java.util.List;
import org.gradle.api.logging.Logger;

public class SpotlessConfigurator {
    private final Logger logger;
    private final PluginConfiguration.FormatterConfiguration formatterConfig;

    public SpotlessConfigurator(Logger logger, PluginConfiguration.FormatterConfiguration formatterConfig) {
        this.logger = logger;
        this.formatterConfig = formatterConfig;
    }

    public void configure(SpotlessExtension se) {
        this.logger.info("dk.mada.style configure spotless");
        se.java(this::configureJava);
    }

    private void configureJava(JavaExtension je) {
        List<String> include = this.formatterConfig.includes();
        List<String> exclude = this.formatterConfig.excludes();
        this.logger.debug("Spotless java include:{} exclude:{}", include, exclude);
        je.target(new Object[]{include});
        je.targetExclude(new Object[]{exclude});
        je.palantirJavaFormat();
        je.formatAnnotations();
    }
}

