/*
 * Decompiled with CFR 0.152.
 */
package org.valkyriercp.sample.simple.domain;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.valkyriercp.sample.simple.domain.Address;
import org.valkyriercp.sample.simple.domain.Contact;
import org.valkyriercp.sample.simple.domain.ContactType;
import org.valkyriercp.sample.simple.domain.TodoItem;

public class ContactDataStore {
    private static int nextId = 1;
    private HashSet contacts = new HashSet();

    public ContactDataStore() {
        this.loadData();
    }

    public Contact[] getAllContacts() {
        return this.contacts.toArray(new Contact[0]);
    }

    public void update(Contact contact) {
        this.contacts.add(contact);
    }

    public void delete(Contact contact) {
        this.contacts.remove(contact);
    }

    public void add(Contact contact) {
        contact.setId(nextId++);
        this.contacts.add(contact);
    }

    private void loadData() {
        this.contacts.add(this.makeContact("Larry", "Streepy", "123 Some St.", "Apt. #26C", "New York", "NY", "10010", ContactType.BUSINESS, "Lorem ipsum..."));
        this.contacts.add(this.makeContact("Keith", "Donald", "456 WebFlow Rd.", "2", "Cooltown", "NY", "10001", ContactType.BUSINESS, "Lorem ipsum..."));
        this.contacts.add(this.makeContact("Steve", "Brothers", "10921 The Other Street", "", "Denver", "CO", "81234-2121", ContactType.PERSONAL, "Lorem ipsum..."));
        this.contacts.add(this.makeContact("Carlos", "Mencia", "4321 Comedy Central", "", "Hollywood", "CA", "91020", ContactType.PERSONAL, "Lorem ipsum..."));
        this.contacts.add(this.makeContact("Jim", "Jones", "1001 Another Place", "", "Dallas", "TX", "71212", ContactType.PERSONAL, "Lorem ipsum..."));
        this.contacts.add(this.makeContact("Jenny", "Jones", "1001 Another Place", "", "Dallas", "TX", "75201", ContactType.PERSONAL, "Lorem ipsum..."));
        this.contacts.add(this.makeContact("Greg", "Jones", "9 Some Other Place", "Apt. 12D", "Chicago", "IL", "60601", ContactType.PERSONAL, "Lorem ipsum..."));
    }

    private List<TodoItem> getTodoItemList() {
        ArrayList<TodoItem> l = new ArrayList<TodoItem>();
        l.add(new TodoItem("test", "test", new Date()));
        return l;
    }

    private Contact makeContact(String first, String last, String address1, String address2, String city, String state, String zip, ContactType contactType, String memo) {
        Contact contact = new Contact();
        contact.setId(nextId++);
        contact.setContactType(contactType);
        contact.setFirstName(first);
        contact.setLastName(last);
        contact.setMemo(memo);
        Address address = contact.getAddress();
        address.setAddress1(address1);
        address.setAddress2(address2);
        address.setCity(city);
        address.setState(state);
        address.setZip(zip);
        contact.setTodoItems(this.getTodoItemList());
        return contact;
    }
}

