/*
 * Decompiled with CFR 0.152.
 */
package org.valkyriercp.sample.simple.domain;

import java.util.Date;
import org.valkyriercp.rules.Rules;
import org.valkyriercp.rules.constraint.Constraint;
import org.valkyriercp.rules.support.DefaultRulesSource;
import org.valkyriercp.sample.simple.domain.Contact;

public class SimpleValidationRulesSource
extends DefaultRulesSource {
    private final Constraint NAME_CONSTRAINT = this.all(new Constraint[]{this.required(), this.minLength(2), this.regexp("[-'.a-zA-Z ]*", "alphabeticConstraint")});
    private final Constraint ZIPCODE_CONSTRAINT = this.all(new Constraint[]{this.required(), this.minLength(5), this.maxLength(10), this.regexp("[0-9]{5}(-[0-9]{4})?", "zipcodeConstraint")});
    private final Constraint EMAIL_CONSTRAINT = this.all(new Constraint[]{this.regexp("([-a-zA-Z0-9.]+@[-a-zA-Z0-9.]+)?", "emailConstraint")});
    private final Constraint PHONE_CONSTRAINT = this.all(new Constraint[]{this.regexp("([0-9]{3}-[0-9]{3}-[0-9]{4})?", "phoneConstraint")});

    public SimpleValidationRulesSource() {
        this.addRules(this.createContactRules());
    }

    private Rules createContactRules() {
        return new Rules(Contact.class){

            protected void initRules() {
                this.add("firstName", SimpleValidationRulesSource.this.NAME_CONSTRAINT);
                this.add("lastName", SimpleValidationRulesSource.this.NAME_CONSTRAINT);
                this.add(this.not(this.eqProperty("firstName", "lastName")));
                this.add("dateOfBirth", this.lt(new Date()));
                this.add("emailAddress", SimpleValidationRulesSource.this.EMAIL_CONSTRAINT);
                this.add("homePhone", SimpleValidationRulesSource.this.PHONE_CONSTRAINT);
                this.add("workPhone", SimpleValidationRulesSource.this.PHONE_CONSTRAINT);
                this.add("contactType", this.required());
                this.add("address.address1", this.required());
                this.add("address.city", this.required());
                this.add("address.state", this.required());
                this.add("address.zip", SimpleValidationRulesSource.this.ZIPCODE_CONSTRAINT);
                this.add("memo", this.required());
            }
        };
    }
}

