/*
 * Decompiled with CFR 0.152.
 */
package org.valkyriercp.sample.simple.ui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Configurable;
import org.springframework.beans.factory.aspectj.AbstractDependencyInjectionAspect;
import org.springframework.beans.factory.aspectj.AnnotationBeanConfigurerAspect;
import org.springframework.context.ApplicationEvent;
import org.valkyriercp.application.PageComponentContext;
import org.valkyriercp.application.event.LifecycleApplicationEvent;
import org.valkyriercp.application.support.AbstractView;
import org.valkyriercp.binding.value.ValueModel;
import org.valkyriercp.command.ActionCommandExecutor;
import org.valkyriercp.command.SecuredActionCommandExecutor;
import org.valkyriercp.command.support.AbstractActionCommandExecutor;
import org.valkyriercp.command.support.AbstractCommand;
import org.valkyriercp.command.support.ActionCommand;
import org.valkyriercp.command.support.CommandGroup;
import org.valkyriercp.core.Authorizable;
import org.valkyriercp.core.Guarded;
import org.valkyriercp.dialog.ConfirmationDialog;
import org.valkyriercp.list.ListSelectionValueModelAdapter;
import org.valkyriercp.list.ListSingleSelectionGuard;
import org.valkyriercp.sample.simple.domain.Contact;
import org.valkyriercp.sample.simple.domain.ContactDataStore;
import org.valkyriercp.sample.simple.ui.ContactPropertiesDialog;
import org.valkyriercp.sample.simple.ui.ContactTable;
import org.valkyriercp.util.PopupMenuMouseListener;
import org.valkyriercp.widget.table.PropertyColumnTableDescription;
import org.valkyriercp.widget.table.TableDescription;
import org.valkyriercp.widget.table.glazedlists.GlazedListTableWidget;

public class ContactView
extends AbstractView {
    private GlazedListTableWidget widget;
    private ContactDataStore contactDataStore;
    private ActionCommandExecutor newContactExecutor;
    private SecuredActionCommandExecutor propertiesExecutor;
    private SecuredActionCommandExecutor deleteExecutor;
    private JTextField filterField;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ContactView() {
        super("contactView");
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        this.newContactExecutor = new NewContactExecutor();
        this.propertiesExecutor = new PropertiesExecutor(this, null);
        this.deleteExecutor = new DeleteExecutor(this, null);
        if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
            AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
        }
    }

    protected ContactDataStore getContactDataStore() {
        return this.contactDataStore;
    }

    public void setContactDataStore(ContactDataStore contactDataStore) {
        this.contactDataStore = contactDataStore;
    }

    protected JComponent createControl() {
        PropertyColumnTableDescription desc = new PropertyColumnTableDescription("contactViewTable", Contact.class);
        desc.addPropertyColumn("lastName").withMinWidth(150);
        desc.addPropertyColumn("firstName").withMinWidth(150);
        desc.addPropertyColumn("address.address1");
        desc.addPropertyColumn("address.city");
        desc.addPropertyColumn("address.state");
        desc.addPropertyColumn("address.zip");
        this.widget = new GlazedListTableWidget(Arrays.asList(this.contactDataStore.getAllContacts()), (TableDescription)desc);
        JPanel table = new JPanel(new BorderLayout());
        table.add((Component)this.widget.getListSummaryLabel(), "North");
        table.add((Component)this.widget.getComponent(), "Center");
        table.add((Component)this.widget.getButtonBar(), "South");
        CommandGroup popup = new CommandGroup();
        popup.add((AbstractCommand)((ActionCommand)this.getWindowCommandManager().getCommand("deleteCommand", ActionCommand.class)));
        popup.addSeparator();
        popup.add((AbstractCommand)((ActionCommand)this.getWindowCommandManager().getCommand("propertiesCommand", ActionCommand.class)));
        JPopupMenu popupMenu = popup.createPopupMenu();
        this.widget.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int rowUnderMouse;
                if (e.getButton() == 3 && (rowUnderMouse = ContactView.this.widget.getTable().rowAtPoint(e.getPoint())) != -1 && !ContactView.this.widget.getTable().isRowSelected(rowUnderMouse)) {
                    ContactView.this.widget.getTable().getSelectionModel().setSelectionInterval(rowUnderMouse, rowUnderMouse);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2 && ContactView.this.propertiesExecutor.isEnabled()) {
                    ContactView.this.propertiesExecutor.execute();
                }
            }
        });
        this.widget.getTable().addMouseListener((MouseListener)new PopupMenuMouseListener(popupMenu));
        ListSelectionValueModelAdapter selectionHolder = new ListSelectionValueModelAdapter(this.widget.getTable().getSelectionModel());
        new ListSingleSelectionGuard((ValueModel)selectionHolder, (Guarded)this.deleteExecutor);
        new ListSingleSelectionGuard((ValueModel)selectionHolder, (Guarded)this.propertiesExecutor);
        JPanel view = new JPanel(new BorderLayout());
        view.add((Component)this.widget.getTextFilterField(), "North");
        view.add((Component)table, "Center");
        return view;
    }

    protected void registerLocalCommandExecutors(PageComponentContext context) {
        context.register("newContactCommand", this.newContactExecutor);
        context.register("propertiesCommand", (ActionCommandExecutor)this.propertiesExecutor);
        this.applicationConfig.securityControllerManager().addSecuredObject((Authorizable)this.propertiesExecutor);
        context.register("deleteCommand", (ActionCommandExecutor)this.deleteExecutor);
        this.applicationConfig.securityControllerManager().addSecuredObject((Authorizable)this.deleteExecutor);
    }

    static {
        ContactView.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ContactView.java", ContactView.class);
        ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1", "org.valkyriercp.sample.simple.ui.ContactView", "", "", ""), 92);
    }

    private class ContactTableFactory {
        private ContactTableFactory() {
        }

        public ContactTable createContactTable() {
            ContactTable contactTable = new ContactTable(ContactView.this.contactDataStore);
            contactTable.setDoubleClickHandler((ActionCommandExecutor)ContactView.this.propertiesExecutor);
            EventList baseList = contactTable.getBaseEventList();
            TextFilterator filterator = GlazedLists.textFilterator((String[])new String[]{"lastName", "address.address1"});
            FilterList filterList = new FilterList(baseList, (MatcherEditor)new TextComponentMatcherEditor((JTextComponent)ContactView.this.filterField, filterator));
            contactTable.setFinalEventList((EventList)filterList);
            CommandGroup popup = new CommandGroup();
            popup.add((AbstractCommand)((ActionCommand)ContactView.this.getWindowCommandManager().getCommand("deleteCommand", ActionCommand.class)));
            popup.addSeparator();
            popup.add((AbstractCommand)((ActionCommand)ContactView.this.getWindowCommandManager().getCommand("propertiesCommand", ActionCommand.class)));
            contactTable.setPopupCommandGroup(popup);
            contactTable.setStatusBar(ContactView.this.getStatusBar());
            ListSelectionValueModelAdapter selectionHolder = new ListSelectionValueModelAdapter(contactTable.getSelectionModel());
            new ListSingleSelectionGuard((ValueModel)selectionHolder, (Guarded)ContactView.this.deleteExecutor);
            new ListSingleSelectionGuard((ValueModel)selectionHolder, (Guarded)ContactView.this.propertiesExecutor);
            return contactTable;
        }
    }

    private class DeleteExecutor
    extends AbstractActionCommandExecutor {
        final /* synthetic */ ContactView this$0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        private DeleteExecutor(ContactView contactView) {
            this.this$0 = contactView;
            ContactView contactView2 = contactView;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)((Object)contactView2));
            this.setAuthorities(new String[]{"ADMIN"});
            if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
                AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
            }
        }

        public void execute() {
            String title = this.this$0.getApplicationConfig().messageResolver().getMessage("contact.confirmDelete.title");
            String message = this.this$0.getApplicationConfig().messageResolver().getMessage("contact.confirmDelete.message");
            ConfirmationDialog dlg = new ConfirmationDialog(title, message){
                private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
                {
                    DeleteExecutor deleteExecutor2 = DeleteExecutor.this;
                    String string = $anonymous0;
                    String string2 = $anonymous1;
                    Object[] objectArray = new Object[]{deleteExecutor2, string, string2};
                    JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
                    if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
                        AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
                    }
                }

                protected void onConfirm() {
                    Object[] objectArray = DeleteExecutor.this.this$0.widget.getSelectedRows();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object selected = objectArray[n2];
                        Contact contact = (Contact)selected;
                        DeleteExecutor.this.this$0.getContactDataStore().delete(contact);
                        this.getApplicationConfig().applicationContext().publishEvent((ApplicationEvent)new LifecycleApplicationEvent("lifecycleEvent.deleted", (Object)contact));
                        ++n2;
                    }
                }

                static {
                    1.ajc$preClinit();
                }

                private static /* synthetic */ void ajc$preClinit() {
                    Factory factory = new Factory("ContactView.java", 1.class);
                    ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("0", "org.valkyriercp.sample.simple.ui.ContactView$DeleteExecutor$1", "org.valkyriercp.sample.simple.ui.ContactView$DeleteExecutor:java.lang.String:java.lang.String", "arg0:$anonymous0:$anonymous1", ""), 304);
                }
            };
            dlg.showDialog();
        }

        /* synthetic */ DeleteExecutor(ContactView contactView, DeleteExecutor deleteExecutor) {
            ContactView contactView2 = contactView;
            DeleteExecutor ajc$aspectInstance = this;
            ajc$aspectInstance.this$0 = contactView2;
            ContactView contactView3 = contactView;
            DeleteExecutor deleteExecutor2 = deleteExecutor;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)((Object)contactView3), (Object)((Object)deleteExecutor2));
            ajc$aspectInstance.setAuthorities(new String[]{"ADMIN"});
            if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
                AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
            }
        }

        static {
            DeleteExecutor.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ContactView.java", DeleteExecutor.class);
            ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "org.valkyriercp.sample.simple.ui.ContactView$DeleteExecutor", "org.valkyriercp.sample.simple.ui.ContactView", "arg0", ""), 296);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "org.valkyriercp.sample.simple.ui.ContactView$DeleteExecutor", "org.valkyriercp.sample.simple.ui.ContactView:org.valkyriercp.sample.simple.ui.ContactView$DeleteExecutor", "arg0:arg1", ""), 297);
        }
    }

    private class NewContactExecutor
    implements ActionCommandExecutor {
        private NewContactExecutor() {
        }

        public void execute() {
            new ContactPropertiesDialog(ContactView.this.getContactDataStore()).showDialog();
        }
    }

    private class PropertiesExecutor
    extends AbstractActionCommandExecutor {
        final /* synthetic */ ContactView this$0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

        private PropertiesExecutor(ContactView contactView) {
            this.this$0 = contactView;
            ContactView contactView2 = contactView;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)((Object)contactView2));
            if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
                AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
            }
        }

        public void execute() {
            Object[] objectArray = this.this$0.widget.getSelectedRows();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object selected = objectArray[n2];
                new ContactPropertiesDialog((Contact)selected, this.this$0.getContactDataStore()).showDialog();
                ++n2;
            }
        }

        /* synthetic */ PropertiesExecutor(ContactView contactView, PropertiesExecutor propertiesExecutor) {
            ContactView contactView2 = contactView;
            PropertiesExecutor ajc$aspectInstance = this;
            ajc$aspectInstance.this$0 = contactView2;
            ContactView contactView3 = contactView;
            PropertiesExecutor propertiesExecutor2 = propertiesExecutor;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)((Object)contactView3), (Object)((Object)propertiesExecutor2));
            if (!AnnotationBeanConfigurerAspect.ajc$if$bb0((Configurable)((Object)((Object)this)).getClass().getAnnotation(Configurable.class)) && AbstractDependencyInjectionAspect.ajc$if$6f1((JoinPoint)joinPoint)) {
                AnnotationBeanConfigurerAspect.aspectOf().ajc$afterReturning$org_springframework_beans_factory_aspectj_AbstractDependencyInjectionAspect$2$1ea6722c((Object)this);
            }
        }

        static {
            PropertiesExecutor.ajc$preClinit();
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ContactView.java", PropertiesExecutor.class);
            ajc$tjp_0 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("2", "org.valkyriercp.sample.simple.ui.ContactView$PropertiesExecutor", "org.valkyriercp.sample.simple.ui.ContactView", "arg0", ""), 280);
            ajc$tjp_1 = factory.makeSJP("initialization", (Signature)factory.makeConstructorSig("1000", "org.valkyriercp.sample.simple.ui.ContactView$PropertiesExecutor", "org.valkyriercp.sample.simple.ui.ContactView:org.valkyriercp.sample.simple.ui.ContactView$PropertiesExecutor", "arg0:arg1", ""), 280);
        }
    }
}

