/*
 * Decompiled with CFR 0.152.
 */
package org.valkyriercp.sample.simple.ui;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;
import org.valkyriercp.binding.format.Formatter;
import org.valkyriercp.binding.format.InvalidFormatException;
import org.valkyriercp.binding.format.support.AbstractFormatter;
import org.valkyriercp.binding.format.support.DateFormatter;
import org.valkyriercp.binding.format.support.SimpleFormatterFactory;

public class SimpleAppFormatterFactory
extends SimpleFormatterFactory {
    public Formatter getDateTimeFormatter() {
        return new AppDateFormatter();
    }

    class AppDateFormatter
    extends AbstractFormatter {
        private final DateFormatter format = new DateFormatter((DateFormat)new SimpleDateFormat("MM-dd-yyyy"));
        private final Pattern MDY_PATTERN = Pattern.compile("[0-9]{1,2}-[0-9]{1,2}-[0-9]{4}");

        AppDateFormatter() {
        }

        protected String doFormatValue(Object value) {
            return value == null ? "" : this.format.formatValue(value);
        }

        protected Object doParseValue(String formattedString, Class targetClass) throws InvalidFormatException, ParseException {
            String src = formattedString;
            if (src.indexOf(47) >= 0) {
                src = src.replace('/', '-');
            }
            Object value = null;
            if (StringUtils.hasText((String)src)) {
                Matcher matcher = this.MDY_PATTERN.matcher(src);
                if (!matcher.matches()) {
                    throw new ParseException("Invalid date format: " + src, 0);
                }
                value = this.format.parseValue(src, Date.class);
            }
            return value;
        }
    }
}

