/*
 * Decompiled with CFR 0.152.
 */
package dk.netdesign.common.osgi.config.test.consumer;

import dk.netdesign.common.osgi.config.enhancement.PropertyActions;
import dk.netdesign.common.osgi.config.osgi.service.ManagedPropertiesService;
import dk.netdesign.common.osgi.config.test.consumer.DefaultProperties;
import dk.netdesign.common.osgi.config.test.consumer.InheritedProperties;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consumer
implements BundleActivator {
    private static final Logger logger = LoggerFactory.getLogger(Consumer.class);
    private InheritedProperties props;
    private Thread printer;
    private boolean run = true;
    private ServiceReference<ManagedPropertiesService> factoryReg;

    public void start(BundleContext context) throws Exception {
        this.factoryReg = context.getServiceReference(ManagedPropertiesService.class);
        ManagedPropertiesService factory = (ManagedPropertiesService)context.getService(this.factoryReg);
        if (factory == null) {
            logger.error("Could not get ManagedPropertiesService");
        }
        this.props = (InheritedProperties)factory.register(InheritedProperties.class, (Object)new DefaultProperties(), context);
        logger.info("Getting properties");
        logger.info(this.props.getCharacterProperty() + "");
        logger.info(this.props.getDoubleProperty() + "");
        logger.info(this.props.getStringInteger() + "");
        logger.info(this.props.getStringProperty() + "");
        logger.info(this.props.getStringListProperty() + "");
        logger.info(this.props.getSubString());
        logger.info(this.props.getFileListProperty() + "");
        logger.info(this.props + "");
        this.printer = new PrinterThread();
        this.printer.start();
    }

    public void stop(BundleContext context) throws Exception {
        ((PropertyActions)this.props).unregisterProperties();
        context.ungetService(this.factoryReg);
        this.run = false;
    }

    private class PrinterThread
    extends Thread {
        public PrinterThread() {
            this.setName("TestConsumer PrinterThread");
        }

        @Override
        public void run() {
            while (Consumer.this.run) {
                logger.info(Consumer.this.props.toString());
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException ex) {
                    logger.warn("Consumer interrupted", (Throwable)ex);
                    Consumer.this.run = false;
                }
            }
        }
    }
}

