/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class ByteUtils {
    public static boolean allEquals(byte[] array, byte value, int offset, int maxLength) {
        maxLength = Math.min(offset + maxLength, array.length);
        for (int i = offset; i < maxLength; ++i) {
            if (array[i] == value) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(byte[] array, byte needle, int offset, int maxLength) {
        int result = -1;
        maxLength = Math.min(offset + maxLength, array.length);
        for (int i = offset; i < maxLength; ++i) {
            if (array[i] != needle) continue;
            result = i;
            break;
        }
        return result;
    }

    public static byte[] trim(byte[] src, byte padding, boolean right, int minLength) {
        if (src.length < minLength) {
            throw new RuntimeException("src array is smaller than minLength: " + src.length + " < " + minLength);
        }
        if (right) {
            int offset;
            for (offset = src.length - 1; offset > minLength - 1 && padding == src[offset]; --offset) {
            }
            if (offset < 0) {
                return new byte[0];
            }
            if (offset < src.length - 1) {
                return Arrays.copyOfRange(src, 0, offset + 1);
            }
        } else {
            int offset;
            for (offset = 0; offset < src.length - minLength && padding == src[offset]; ++offset) {
            }
            if (offset == src.length) {
                return new byte[0];
            }
            if (offset > 0) {
                return Arrays.copyOfRange(src, offset, src.length);
            }
        }
        return src;
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        int r;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buf = new byte[8192];
        while ((r = inputStream.read(buf)) != -1) {
            outputStream.write(buf, 0, r);
        }
        return outputStream.toByteArray();
    }
}

