/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook;

import dk.nversion.ByteUtils;
import dk.nversion.copybook.exceptions.CopyBookException;
import dk.nversion.copybook.serializers.CopyBookMapper;
import dk.nversion.copybook.serializers.CopyBookParser;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class CopyBookSerializer {
    private CopyBookMapper serializer;

    public CopyBookSerializer(Class<?> type) {
        this(type, false);
    }

    public CopyBookSerializer(Class<?> type, boolean debug) {
        this(type, null, debug);
    }

    public CopyBookSerializer(Class<?> type, Class<CopyBookMapper> mapper, boolean debug) {
        CopyBookParser parser = new CopyBookParser(type, debug);
        try {
            this.serializer = mapper != null ? mapper.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : parser.getSerializerClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            this.serializer.initialize(parser.getConfig());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new CopyBookException("Failed to load Serialization class(" + parser.getSerializerClass().getSimpleName() + ")", e);
        }
    }

    public <T> byte[] serialize(T obj) {
        return this.serializer.serialize(obj);
    }

    public <T> T deserialize(byte[] bytes, Class<T> type) {
        return this.serializer.deserialize(bytes, type);
    }

    public <T> T deserialize(InputStream inputStream, Class<T> type) throws IOException {
        return this.deserialize(ByteUtils.toByteArray(inputStream), type);
    }

    public List<CopyBookException> getErrors() {
        return null;
    }

    public int getMinRecordSize() {
        return this.serializer.getMinRecordSize();
    }

    public int getMaxRecordSize() {
        return this.serializer.getMaxRecordSize();
    }
}

