/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.converters;

import dk.nversion.copybook.converters.IntegerToInteger;
import dk.nversion.copybook.exceptions.TypeConverterException;

public class IntegerToBoolean
extends IntegerToInteger {
    @Override
    public void validate(Class<?> type, int size, int decimals) {
        if (!Boolean.class.equals(type) && !Boolean.TYPE.equals(type)) {
            throw new TypeConverterException("Only supports converting to and from int or Integer");
        }
    }

    @Override
    public Object to(byte[] bytes, int offset, int length, int decimals, boolean removePadding) {
        return (Integer)super.to(bytes, offset, length, decimals, removePadding) != 0;
    }

    @Override
    public byte[] from(Object value, int length, int decimals, boolean addPadding) {
        return super.from(value != null ? Integer.valueOf((Boolean)value != false ? 1 : 0) : null, length, decimals, addPadding);
    }
}

