/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.converters;

import dk.nversion.copybook.converters.IntegerToInteger;
import dk.nversion.copybook.converters.TypeConverterIntEnum;
import dk.nversion.copybook.exceptions.TypeConverterException;
import java.util.HashMap;
import java.util.Map;

public class IntegerToTypeConverterIntEnum
extends IntegerToInteger {
    Class<?> type;
    Object[] enumConstants;
    Map<Integer, Object> toEnumMap = new HashMap<Integer, Object>();
    Map<Object, byte[]> fromEnumMap = new HashMap<Object, byte[]>();

    @Override
    public void validate(Class<?> type, int size, int decimals) {
        if (!TypeConverterIntEnum.class.isAssignableFrom(type)) {
            throw new TypeConverterException("Only supports converting to and from TypeConverterIntEnum");
        }
        if (this.type != null && this.type != type) {
            throw new TypeConverterException("Type converter can only be used on " + type.getSimpleName() + " fields");
        }
        this.type = type;
        this.enumConstants = type.getEnumConstants();
        if (this.enumConstants == null || this.enumConstants.length == 0) {
            throw new TypeConverterException("Could not find any enum constants on type");
        }
        for (Object enumConstant : this.enumConstants) {
            int value = ((TypeConverterIntEnum)enumConstant).getValue();
            this.toEnumMap.put(value, enumConstant);
            this.fromEnumMap.put(enumConstant, Integer.toString(value).getBytes(this.charset));
        }
    }

    @Override
    public Object to(byte[] bytes, int offset, int length, int decimals, boolean removePadding) {
        int i = (Integer)super.to(bytes, offset, length, decimals, removePadding);
        if (this.toEnumMap.size() > 0) {
            if (this.toEnumMap.containsKey(i)) {
                return this.toEnumMap.get(i);
            }
            throw new TypeConverterException("Unknown value for enum: " + i);
        }
        if (i < this.enumConstants.length) {
            return this.enumConstants[i];
        }
        throw new TypeConverterException("Unknown ordinal value for enum: " + i);
    }

    @Override
    public byte[] from(Object value, int length, int decimals, boolean addPadding) {
        if (value == null && this.defaultValue == null) {
            return null;
        }
        byte[] strBytes = this.fromEnumMap.get(value);
        if (strBytes.length > length) {
            throw new TypeConverterException("Field to small for value: " + length + " < " + strBytes.length);
        }
        if (addPadding) {
            strBytes = this.padBytes(strBytes, length);
        }
        return strBytes;
    }
}

