/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.converters;

import dk.nversion.ByteUtils;
import dk.nversion.copybook.converters.SignedIntegerToInteger;
import dk.nversion.copybook.exceptions.TypeConverterException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public class SignedDecimalToBigDecimal
extends SignedIntegerToInteger {
    @Override
    public void validate(Class<?> type, int size, int decimals) {
        if (!BigDecimal.class.equals(type)) {
            throw new TypeConverterException("Only supports converting to and from BigDecimal");
        }
    }

    @Override
    public Object to(byte[] bytes, int offset, int length, int decimals, boolean removePadding) {
        if (this.defaultValue != null && ByteUtils.allEquals(bytes, this.nullFillerByte, offset, bytes.length)) {
            return new BigDecimal(this.defaultValue);
        }
        return new BigDecimal(new BigInteger(this.getSignedIntegerString(bytes, offset, length, removePadding)), decimals);
    }

    @Override
    public byte[] from(Object value, int length, int decimals, boolean addPadding) {
        byte[] strBytes;
        if (value == null && this.defaultValue == null) {
            return null;
        }
        BigDecimal i = value != null ? (BigDecimal)value : new BigDecimal(this.defaultValue);
        BigInteger absValue = i.movePointRight(decimals).toBigInteger().abs();
        String strValue = absValue.toString();
        if (absValue.signum() == 0) {
            char[] chars = new char[decimals];
            Arrays.fill(chars, '0');
            strValue = strValue + new String(chars);
        }
        if ((strBytes = this.getSignedBytes(strValue, i.signum() < 0)).length > length) {
            throw new TypeConverterException("Field to small for value: " + length + " < " + strBytes.length);
        }
        if (addPadding) {
            strBytes = this.padBytes(strBytes, length);
        }
        return strBytes;
    }
}

