/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.converters;

import dk.nversion.ByteUtils;
import dk.nversion.copybook.converters.TypeConverterBase;
import dk.nversion.copybook.exceptions.TypeConverterException;
import dk.nversion.copybook.serializers.CopyBookFieldSigningType;
import java.util.Arrays;

public class SignedIntegerToInteger
extends TypeConverterBase {
    @Override
    public void validate(Class<?> type, int size, int decimals) {
        if (size > 10 && (this.signingType == CopyBookFieldSigningType.PREFIX || this.signingType == CopyBookFieldSigningType.POSTFIX)) {
            throw new TypeConverterException("int is not large enough to hold possible value");
        }
        if (size > 9 && (this.signingType == CopyBookFieldSigningType.LAST_BYTE_BIT8 || this.signingType == CopyBookFieldSigningType.LAST_BYTE_EBCDIC_BIT5)) {
            throw new TypeConverterException("int is not large enough to hold possible value");
        }
        if (!Integer.class.equals(type) && !Integer.TYPE.equals(type)) {
            throw new TypeConverterException("Only supports converting to and from int or Integer");
        }
    }

    @Override
    public Object to(byte[] bytes, int offset, int length, int decimals, boolean removePadding) {
        if (this.defaultValue != null && ByteUtils.allEquals(bytes, this.nullFillerByte, offset, bytes.length)) {
            return Integer.parseInt(this.defaultValue);
        }
        return Integer.parseInt(this.getSignedIntegerString(bytes, offset, length, removePadding));
    }

    @Override
    public byte[] from(Object value, int length, int decimals, boolean addPadding) {
        if (value == null && this.defaultValue == null) {
            return null;
        }
        int i = value != null ? (Integer)value : Integer.parseInt(this.defaultValue);
        byte[] strBytes = this.getSignedBytes(Integer.toString(Math.abs(i)), i < 0);
        if (strBytes.length > length) {
            throw new TypeConverterException("Field to small for value: " + length + " < " + strBytes.length);
        }
        if (addPadding) {
            strBytes = this.padBytes(strBytes, length);
        }
        return strBytes;
    }

    protected String getSignedIntegerString(byte[] bytes, int offset, int length, boolean removePadding) {
        String strValue;
        if (this.signingType == CopyBookFieldSigningType.POSTFIX) {
            strValue = this.normalizeNumericSigning(this.getString(bytes, offset, length, removePadding, 2), true);
        } else if (this.signingType == CopyBookFieldSigningType.PREFIX) {
            strValue = this.normalizeNumericSigning(this.getString(bytes, offset, length, removePadding, 2), false);
        } else if (this.signingType == CopyBookFieldSigningType.LAST_BYTE_BIT8) {
            if ((bytes[bytes.length - 1] & 0x80) != 0) {
                byte[] bytesCopy = Arrays.copyOf(bytes, bytes.length);
                bytesCopy[bytesCopy.length - 1] = (byte)(bytesCopy[bytesCopy.length - 1] & 0x7F);
                strValue = "-" + this.getString(bytesCopy, 0, bytesCopy.length, removePadding, 1);
            } else {
                strValue = this.getString(bytes, offset, length, removePadding, 1);
            }
        } else if (this.signingType == CopyBookFieldSigningType.LAST_BYTE_EBCDIC_BIT5) {
            byte res = (byte)(bytes[bytes.length - 1] & 0xF0);
            byte[] bytesCopy = Arrays.copyOf(bytes, bytes.length - 1);
            strValue = (byte)(res ^ 0xD0) == 0 || (byte)(res ^ 0xB0) == 0 ? "-" + this.getString(bytesCopy, offset, length - 1, removePadding, 1) + String.valueOf(bytes[bytes.length - 1] & 0xF) : this.getString(bytesCopy, offset, bytesCopy.length, removePadding, 1) + String.valueOf(bytes[bytes.length - 1] & 0xF);
        } else {
            throw new TypeConverterException("Unknown signing type");
        }
        return strValue;
    }

    protected byte[] getSignedBytes(String strValue, boolean negative) {
        byte[] strBytes;
        if (this.signingType == CopyBookFieldSigningType.POSTFIX) {
            strBytes = (strValue + (negative ? Character.valueOf('-') : "+")).getBytes(this.charset);
        } else if (this.signingType == CopyBookFieldSigningType.PREFIX) {
            strBytes = ((negative ? Character.valueOf('-') : "+") + strValue).getBytes(this.charset);
        } else if (this.signingType == CopyBookFieldSigningType.LAST_BYTE_BIT8) {
            strBytes = strValue.getBytes(this.charset);
            strBytes[strBytes.length - 1] = negative ? (byte)(strBytes[strBytes.length - 1] | 0x80) : (byte)(strBytes[strBytes.length - 1] & 0x7F);
        } else if (this.signingType == CopyBookFieldSigningType.LAST_BYTE_EBCDIC_BIT5) {
            strBytes = strValue.getBytes(this.charset);
            strBytes[strBytes.length - 1] = (byte)(strBytes[strBytes.length - 1] & 0xF);
            strBytes[strBytes.length - 1] = negative ? (byte)(strBytes[strBytes.length - 1] | 0xD0) : (byte)(strBytes[strBytes.length - 1] | 0xC0);
        } else {
            throw new TypeConverterException("Unknown signing type");
        }
        return strBytes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String normalizeNumericSigning(String str, boolean signingPostfix) {
        if (signingPostfix) {
            if (str.endsWith("-")) {
                return '-' + str.substring(0, str.length() - 1);
            }
            if (!str.endsWith("+")) throw new TypeConverterException("Missing sign char for value '" + str + "'");
            return str.substring(0, str.length() - 1);
        }
        if (str.startsWith("+")) {
            return str.substring(1, str.length());
        }
        if (!str.startsWith("-")) throw new TypeConverterException("Missing sign char for value '" + str + "'");
        return str;
    }

    private String debugBitmap(byte[] bytes, int index, int length) {
        String result = "";
        for (int i = index; i < length; ++i) {
            result = result + ("0000000" + Integer.toBinaryString(bytes[i] & 0xFF)).replaceAll(".*(.{8})$", "$1");
        }
        return result;
    }
}

