/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.converters;

import dk.nversion.copybook.converters.StringToString;
import dk.nversion.copybook.converters.TypeConverterConfig;
import dk.nversion.copybook.exceptions.TypeConverterException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

public class StringToLocalDateTime
extends StringToString {
    DateTimeFormatter formatter;

    @Override
    public void initialize(TypeConverterConfig config) {
        super.initialize(config);
        this.formatter = DateTimeFormatter.ofPattern(this.format);
    }

    @Override
    public void validate(Class<?> type, int size, int decimals) {
        if (!LocalDateTime.class.isAssignableFrom(type)) {
            throw new TypeConverterException("Only supports converting to and from an Enum that is or extends from LocalDateTime");
        }
    }

    @Override
    public Object to(byte[] bytes, int offset, int length, int decimals, boolean removePadding) {
        String value = (String)super.to(bytes, offset, length, decimals, removePadding);
        if (value != null && !value.isEmpty()) {
            return LocalDateTime.parse(value, this.formatter);
        }
        return null;
    }

    @Override
    public byte[] from(Object value, int length, int decimals, boolean addPadding) {
        byte[] strBytes;
        if (value == null) {
            if (this.defaultValue != null) {
                value = LocalDateTime.parse(this.defaultValue, this.formatter);
            } else {
                return null;
            }
        }
        if ((strBytes = ((LocalDateTime)value).format(this.formatter).getBytes(this.charset)).length > length) {
            throw new TypeConverterException("Field to small for value: " + length + " < " + strBytes.length);
        }
        if (addPadding) {
            strBytes = this.padBytes(strBytes, length);
        }
        return strBytes;
    }
}

