/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.converters;

import dk.nversion.copybook.converters.StringToString;
import dk.nversion.copybook.converters.TypeConverterStringEnum;
import dk.nversion.copybook.exceptions.TypeConverterException;
import java.util.HashMap;
import java.util.Map;

public class StringToTypeConverterStringEnum
extends StringToString {
    Class<?> type;
    Object[] enumConstants;
    Map<String, Object> toEnumMap = new HashMap<String, Object>();
    Map<Object, byte[]> fromEnumMap = new HashMap<Object, byte[]>();

    @Override
    public void validate(Class<?> type, int size, int decimals) {
        if (!TypeConverterStringEnum.class.isAssignableFrom(type)) {
            throw new TypeConverterException("Only supports converting to and from an Enum that implements TypeConverterStringEnum");
        }
        if (this.type != null && this.type != type) {
            throw new TypeConverterException("Type converter can only be used on " + type.getSimpleName() + " fields");
        }
        this.type = type;
        this.enumConstants = type.getEnumConstants();
        if (this.enumConstants == null || this.enumConstants.length == 0) {
            throw new TypeConverterException("Could not find any enum constants on type");
        }
        for (Object enumConstant : this.enumConstants) {
            String value = ((TypeConverterStringEnum)enumConstant).getValue();
            this.toEnumMap.put(value, enumConstant);
            this.fromEnumMap.put(enumConstant, value.getBytes(this.charset));
        }
    }

    @Override
    public Object to(byte[] bytes, int offset, int length, int decimals, boolean removePadding) {
        String value = (String)super.to(bytes, offset, length, decimals, removePadding);
        if (this.toEnumMap.containsKey(value)) {
            return this.toEnumMap.get(value);
        }
        throw new TypeConverterException("Unknown value for enum: " + value);
    }

    @Override
    public byte[] from(Object value, int length, int decimals, boolean addPadding) {
        if (value == null && this.defaultValue == null) {
            return null;
        }
        byte[] strBytes = this.fromEnumMap.get(value);
        if (strBytes.length > length) {
            throw new TypeConverterException("Field to small for value: " + length + " < " + strBytes.length);
        }
        if (addPadding) {
            strBytes = this.padBytes(strBytes, length);
        }
        return strBytes;
    }
}

