/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.serializers;

import dk.nversion.copybook.converters.TypeConverter;
import dk.nversion.copybook.exceptions.CopyBookException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.List;

public class CopyBookField {
    private List<CopyBookField> subCopyBookFields;
    private Class<?> type;
    private Field field;
    private String[] lines;
    private TypeConverter converter;
    private String name;
    private int size;
    private int decimals;
    private int minOccurs;
    private int maxOccurs;
    private String counterKey;
    private boolean counter;
    private String redefines;
    private String redefinedOn;
    private String redefineMatch;
    private int recursiveMaxSize;
    private int recursiveMinSize;
    private boolean last;
    private int level;

    public boolean isArray() {
        return this.field.getType().isArray();
    }

    public CopyBookField(Class<?> type, Field field, String name, int size, int decimals, int minOccurs, int maxOccurs, String[] lines, String counterKey, TypeConverter converter) {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        this.type = type;
        this.field = field;
        this.lines = (String[])lines.clone();
        this.counterKey = counterKey;
        this.converter = converter;
        this.name = name;
        this.size = size;
        this.decimals = decimals;
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    public Object setBytes(Object obj, ByteBuffer buffer, boolean removePadding) {
        byte[] bytes = new byte[this.size];
        buffer.get(bytes);
        return this.setBytes(obj, bytes, 0, bytes.length, removePadding);
    }

    public Object setBytes(Object obj, byte[] bytes, boolean removePadding) {
        return this.setBytes(obj, bytes, 0, bytes != null ? bytes.length : 0, removePadding);
    }

    public Object setBytes(Object obj, byte[] bytes, int offset, int length, boolean removePadding) {
        try {
            Object value = bytes != null ? this.converter.to(bytes, offset, length, this.decimals, removePadding) : null;
            this.field.set(obj, value);
            return value;
        }
        catch (IllegalAccessException ex) {
            return null;
        }
        catch (Exception ex) {
            throw new CopyBookException(this.getFieldName() + ": ", ex);
        }
    }

    public Object setBytes(Object obj, int index, ByteBuffer buffer, boolean removePadding) {
        byte[] bytes = new byte[this.size];
        buffer.get(bytes);
        return this.setBytes(obj, index, bytes, 0, bytes.length, removePadding);
    }

    public Object setBytes(Object arrayObj, int index, byte[] bytes, boolean removePadding) {
        return this.setBytes(arrayObj, index, bytes, 0, bytes != null ? bytes.length : 0, removePadding);
    }

    public Object setBytes(Object arrayObj, int index, byte[] bytes, int offset, int length, boolean removePadding) {
        try {
            Object value = bytes != null ? this.converter.to(bytes, offset, length, this.decimals, removePadding) : null;
            Array.set(arrayObj, index, value);
            return value;
        }
        catch (Exception ex) {
            throw new CopyBookException(this.getFieldName() + ": ", ex);
        }
    }

    public byte[] getBytes(Object rootObj, boolean addPadding) {
        return this.getBytes(rootObj, null, addPadding);
    }

    public byte[] getBytes(Object rootObj, Object valueObj, boolean addPadding) {
        try {
            if (valueObj == null) {
                valueObj = this.getObject(rootObj);
            }
            return this.converter.from(valueObj, this.size, this.decimals, addPadding);
        }
        catch (Exception ex) {
            throw new CopyBookException(this.getFieldName() + ": ", ex);
        }
    }

    public byte[] getBytes(Object rootObj, int index, boolean addPadding) {
        return this.getBytes(rootObj, null, index, addPadding);
    }

    public byte[] getBytes(Object rootObj, Object arrayObj, int index, boolean addPadding) {
        try {
            return this.converter.from(this.getObject(rootObj, arrayObj, index), this.size, this.decimals, addPadding);
        }
        catch (Exception ex) {
            throw new CopyBookException(this.getFieldName() + ": ", ex);
        }
    }

    public Object getObject(Object rootObj) {
        try {
            return rootObj != null ? this.field.get(rootObj) : null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Object getObject(Object rootObj, int index) {
        Object array = this.getObject(rootObj);
        return array != null && index < Array.getLength(array) ? Array.get(array, index) : null;
    }

    public Object getObject(Object rootObj, Object arrayObj, int index) {
        if (arrayObj == null) {
            arrayObj = this.getObject(rootObj);
        }
        return arrayObj != null && index < Array.getLength(arrayObj) ? Array.get(arrayObj, index) : null;
    }

    public Object createArrayObject(Object rootObj, int size) {
        try {
            Object array = Array.newInstance(this.field.getType().getComponentType(), size);
            this.field.set(rootObj, array);
            return array;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    public Object createObject(Object rootObj) {
        try {
            Object value = this.field.getType().newInstance();
            this.field.set(rootObj, value);
            return value;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new CopyBookException("Failed to create new object", e);
        }
    }

    public Object createObject(Object obj, int index) {
        try {
            Object value = this.field.getType().getComponentType().newInstance();
            Array.set(obj, index, value);
            return value;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            throw new CopyBookException("Failed to create new object", e);
        }
    }

    public boolean hasSubCopyBookFields() {
        return this.subCopyBookFields != null && this.subCopyBookFields.size() > 0;
    }

    public List<CopyBookField> getSubCopyBookFields() {
        return this.subCopyBookFields;
    }

    public void setSubCopyBookFields(List<CopyBookField> subCopyBookFields) {
        this.subCopyBookFields = subCopyBookFields;
    }

    public String getFieldName() {
        return this.type.getName() + "." + this.field.getName();
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public String[] getLines() {
        return (String[])this.lines.clone();
    }

    public void setLines(String[] lines) {
        this.lines = (String[])lines.clone();
    }

    public TypeConverter getConverter() {
        return this.converter;
    }

    public void setConverter(TypeConverter converter) {
        this.converter = converter;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public String getCounterKey() {
        return this.counterKey;
    }

    public void setCounterKey(String counterKey) {
        this.counterKey = counterKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCounter() {
        return this.counter;
    }

    public void setCounter(boolean counter) {
        this.counter = counter;
    }

    public String getRedefines() {
        return this.redefines;
    }

    public void setRedefines(String redefines) {
        this.redefines = redefines;
    }

    public String getRedefinedOn() {
        return this.redefinedOn;
    }

    public void setRedefinedOn(String redefinedOn) {
        this.redefinedOn = redefinedOn;
    }

    public String getRedefineMatch() {
        return this.redefineMatch;
    }

    public void setRedefineMatch(String redefineMatch) {
        this.redefineMatch = redefineMatch;
    }

    public int getRecursiveMinSize() {
        return this.recursiveMinSize;
    }

    public void setRecursiveMinSize(int recursiveMinSize) {
        this.recursiveMinSize = recursiveMinSize;
    }

    public boolean isLast() {
        return this.last;
    }

    public void setLast(boolean last) {
        this.last = last;
    }

    public int getRecursiveMaxSize() {
        return this.recursiveMaxSize;
    }

    public void setRecursiveMaxSize(int recursiveMaxSize) {
        this.recursiveMaxSize = recursiveMaxSize;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }
}

