/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.serializers;

import dk.nversion.copybook.serializers.CopyBookField;
import dk.nversion.copybook.serializers.CopyBookMapper;
import dk.nversion.copybook.serializers.CopyBookSerializerConfig;
import java.util.List;

public abstract class CopyBookMapperBase
implements CopyBookMapper {
    protected List<CopyBookField> fields;
    protected boolean debug;
    protected boolean strict;
    protected int maxRecordSize;
    protected int minRecordSize;

    @Override
    public void initialize(CopyBookSerializerConfig config) {
        this.fields = config.getFields();
        this.debug = config.isDebug();
        this.strict = config.isStrict();
        int[] totalSizes = this.calculateSizes(config.getFields(), 0, this.debug);
        this.minRecordSize = totalSizes[0];
        this.maxRecordSize = totalSizes[1];
    }

    protected int[] calculateSizes(List<CopyBookField> fields, int level, boolean debug) {
        int minTotal = 0;
        int maxTotal = 0;
        for (int i = 0; i < fields.size(); ++i) {
            int maxSize;
            int minSize;
            CopyBookField field = fields.get(i);
            if (debug) {
                for (String line : field.getLines()) {
                    System.out.println(new String(new char[level * 2]).replace("\u0000", " ") + line);
                }
            }
            if (field.isArray()) {
                if (field.hasSubCopyBookFields()) {
                    int[] sizes = this.calculateSizes(field.getSubCopyBookFields(), level + 1, debug);
                    minSize = sizes[0] * field.getMinOccurs();
                    maxSize = sizes[1] * field.getMaxOccurs();
                } else {
                    minSize = field.getSize() * field.getMinOccurs();
                    maxSize = field.getSize() * field.getMaxOccurs();
                }
            } else if (field.hasSubCopyBookFields()) {
                int[] sizes = this.calculateSizes(field.getSubCopyBookFields(), level + 1, debug);
                minSize = sizes[0];
                maxSize = sizes[1];
            } else {
                maxSize = minSize = field.getSize();
            }
            minTotal += minSize;
            maxTotal += maxSize;
            field.setRecursiveMinSize(minSize);
            field.setRecursiveMaxSize(maxSize);
            field.setLevel(level);
            field.setLast(fields.size() - 1 == i);
        }
        return new int[]{minTotal, maxTotal};
    }

    @Override
    public int getMinRecordSize() {
        return this.minRecordSize;
    }

    @Override
    public void setMinRecordSize(int minRecordSize) {
        this.minRecordSize = minRecordSize;
    }

    @Override
    public int getMaxRecordSize() {
        return this.maxRecordSize;
    }

    @Override
    public void setMaxRecordSize(int maxRecordSize) {
        this.maxRecordSize = maxRecordSize;
    }
}

