/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.serializers;

import dk.nversion.copybook.annotations.CopyBook;
import dk.nversion.copybook.annotations.CopyBookDefaults;
import dk.nversion.copybook.annotations.CopyBookFieldFormat;
import dk.nversion.copybook.annotations.CopyBookFieldFormats;
import dk.nversion.copybook.annotations.CopyBookLine;
import dk.nversion.copybook.annotations.CopyBookRedefine;
import dk.nversion.copybook.converters.TypeConverter;
import dk.nversion.copybook.converters.TypeConverterConfig;
import dk.nversion.copybook.exceptions.CopyBookException;
import dk.nversion.copybook.exceptions.TypeConverterException;
import dk.nversion.copybook.serializers.CopyBookField;
import dk.nversion.copybook.serializers.CopyBookMapper;
import dk.nversion.copybook.serializers.CopyBookSerializerConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CopyBookParser {
    private static Pattern re_CopyBookLine = Pattern.compile("^\\s*(\\d+)\\s+([^\\s]+)((?:\\s+OCCURS\\s+\\d+(?:\\s+TO\\s+\\d+)?(?:\\s+TIMES)?)|(?:\\s+REDEFINES\\s+[^\\s]+))?(\\s+PIC\\s+[^\\s]+)?(\\s+DEPENDING\\s+ON\\s+[^\\s]+(?:\\s+IN\\s+[^\\s+]+)?)?\\s*\\.\\s*$");
    private static Pattern re_Occurs = Pattern.compile("^\\s*OCCURS\\s+(?:(\\d+)\\s+TO\\s+)?(\\d+)(:?\\s+TIMES)?\\s*$");
    private static Pattern re_Redefines = Pattern.compile("\\s*REDEFINES\\s+([^\\s]+)\\s*");
    private static Pattern re_Pic = Pattern.compile("^\\s*PIC\\s+(S)?(X+|9+)(?:\\((\\d+)\\))?(?:V(9+)(?:\\((\\d+)\\))?)?\\s*$");
    private static Pattern re_DependingOn = Pattern.compile("^\\s*DEPENDING\\s+ON\\s+([^\\s]+)(?:\\s+IN\\s+([^\\s]+))?\\s*$");
    private Class<? extends CopyBookMapper> serializerClass = null;
    private CopyBookSerializerConfig config = new CopyBookSerializerConfig();

    public CopyBookParser(Class<?> type) {
        this(type, false);
    }

    public CopyBookParser(Class<?> type, boolean debug) {
        List<CopyBook> copybookAnnotations = this.getAnnotationsRecursively(CopyBookDefaults.class, CopyBook.class);
        copybookAnnotations.addAll(this.getAnnotationsRecursively(type, CopyBook.class));
        for (CopyBook annotation : copybookAnnotations) {
            if (!annotation.type().equals(CopyBookMapper.class)) {
                this.serializerClass = annotation.type();
            }
            if (!annotation.charset().isEmpty()) {
                this.config.setCharset(Charset.forName(annotation.charset()));
            }
            if (annotation.separatorChar() != 'G') {
                this.config.setSeparatorByte((byte)annotation.separatorChar());
            }
            if (annotation.bitmapBlockSize() != 0) {
                this.config.setBitmapBlockSize(annotation.bitmapBlockSize());
            }
            if (!annotation.strict()) continue;
            this.config.setStrict(annotation.strict());
        }
        if (this.serializerClass == null) {
            throw new CopyBookException("Serialization class missing");
        }
        this.config.setDebug(debug);
        Map<String, TypeConverter> defaultTypeConverterMap = this.getTypeConvertersRecursively(CopyBookDefaults.class, this.config.getCharset(), this.config.isStrict());
        this.config.setFields(this.walkClass(type, null, defaultTypeConverterMap, this.config.getCharset(), this.config.isStrict(), new HashMap<String, CopyBookField>()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<CopyBookField> walkClass(Class<?> type, String copyBookName, Map<String, TypeConverter> inheritedTypeConverterMap, Charset charset, boolean strict, Map<String, CopyBookField> copyBookFieldNames) {
        ArrayList<CopyBookField> results = new ArrayList<CopyBookField>();
        CopyBook copyBookAnnotation = type.getAnnotation(CopyBook.class);
        if (copyBookAnnotation == null) {
            throw new CopyBookException("No copybook defined on this class");
        }
        HashMap<String, TypeConverter> typeConverterMap = new HashMap<String, TypeConverter>(inheritedTypeConverterMap);
        typeConverterMap.putAll(this.getTypeConvertersRecursively(type, charset, strict));
        for (Field field : type.getDeclaredFields()) {
            String redefineMatch;
            String[] copyBookLines = (String[])Arrays.stream(field.getAnnotationsByType(CopyBookLine.class)).map(cbl -> cbl.value()).toArray(String[]::new);
            CopyBookRedefine copyBookRedefine = field.getDeclaredAnnotation(CopyBookRedefine.class);
            String redefineOn = copyBookRedefine != null ? copyBookRedefine.on() : null;
            String string = redefineMatch = copyBookRedefine != null ? copyBookRedefine.match() : null;
            if (copyBookLines.length <= 0) continue;
            String fieldName = type.getName() + "." + field.getName();
            Class<?> fieldBaseType = field.getType().isArray() ? field.getType().getComponentType() : field.getType();
            String fieldTypeName = this.getTypeClassSimpleName(fieldBaseType);
            ArrayList<String> names = new ArrayList<String>();
            if (copyBookName != null) {
                names.add(copyBookName);
            }
            int size = 0;
            int decimals = -1;
            int minOccurs = -1;
            int maxOccurs = -1;
            String counterKey = null;
            String copyBookType = null;
            String redefines = null;
            for (String copyBookLine : copyBookLines) {
                Matcher copyBookLineMatcher = re_CopyBookLine.matcher(copyBookLine);
                if (!copyBookLineMatcher.find()) throw new CopyBookException("Could not parse copybook line for field '" + fieldName + "'");
                int level = Integer.parseInt(copyBookLineMatcher.group(1));
                names.add(copyBookLineMatcher.group(2));
                if (copyBookLineMatcher.group(3) != null) {
                    Matcher occursMatcher = re_Occurs.matcher(copyBookLineMatcher.group(3));
                    Matcher redefinesMatcher = re_Redefines.matcher(copyBookLineMatcher.group(3));
                    if (occursMatcher.find()) {
                        maxOccurs = Integer.parseInt(occursMatcher.group(2));
                        minOccurs = occursMatcher.group(1) != null ? Integer.parseInt(occursMatcher.group(1)) : maxOccurs;
                    } else {
                        if (!redefinesMatcher.find()) throw new CopyBookException("Could not parse occurs section in copybook line for field '" + fieldName + "'");
                        redefines = redefinesMatcher.group(1);
                    }
                }
                if (copyBookLineMatcher.group(4) != null) {
                    Matcher picMatcher = re_Pic.matcher(copyBookLineMatcher.group(4));
                    if (!picMatcher.find()) throw new CopyBookException("Could not parse occurs section in copybook line for field '" + fieldName + "'");
                    boolean signed = picMatcher.group(1) != null;
                    String mainType = picMatcher.group(2);
                    int mainSize = picMatcher.group(3) != null ? Integer.parseInt(picMatcher.group(3)) : mainType.length();
                    String decimalType = picMatcher.group(4) != null ? picMatcher.group(4) : "";
                    int decimalSize = picMatcher.group(5) != null ? Integer.parseInt(picMatcher.group(5)) : decimalType.length();
                    size = mainSize + decimalSize;
                    decimals = decimalSize;
                    if (mainType.startsWith("X")) {
                        copyBookType = "String";
                    } else {
                        if (!mainType.startsWith("9")) throw new CopyBookException("Unknown PIC type for field '" + fieldName + "'");
                        copyBookType = !decimalType.isEmpty() ? "Decimal" : "Integer";
                        if (signed) {
                            copyBookType = "Signed" + copyBookType;
                        }
                    }
                }
                if (copyBookLineMatcher.group(5) == null) continue;
                Matcher dependingOnMatcher = re_DependingOn.matcher(copyBookLineMatcher.group(5));
                if (!dependingOnMatcher.find()) throw new CopyBookException("Could not parse depending on section in copybook line for field '" + fieldName + "'");
                String dependedName = dependingOnMatcher.group(1);
                String subFieldName = dependingOnMatcher.group(2);
                ArrayList<String> counterKeyNames = new ArrayList<String>(names.subList(0, names.size() - 1));
                if (subFieldName != null) {
                    if (names.size() <= 1) throw new CopyBookException("IN only makes sense when you are in another level for field '" + fieldName + "'");
                    counterKeyNames.remove(counterKeyNames.size() - 1);
                    counterKeyNames.add(subFieldName);
                }
                counterKeyNames.add(dependedName);
                counterKey = counterKeyNames.stream().collect(Collectors.joining("."));
                if (!copyBookFieldNames.containsKey(counterKey)) throw new CopyBookException("Could not find referenced counter " + counterKey + "for field '" + fieldName + "'");
                copyBookFieldNames.get(counterKey).setCounter(true);
            }
            if (!(minOccurs <= 0 && maxOccurs <= 0 || field.getType().isArray())) {
                throw new CopyBookException("Trying to map array type to non array type for field '" + fieldName + "'");
            }
            HashMap<String, TypeConverter> fieldTypeConverterMap = new HashMap<String, TypeConverter>(typeConverterMap);
            fieldTypeConverterMap.putAll(this.getTypeConvertersRecursively(fieldBaseType, charset, strict));
            TypeConverter typeConverter = null;
            if (copyBookType != null) {
                if (field.getType().isArray()) {
                    typeConverter = (TypeConverter)fieldTypeConverterMap.get(copyBookType + "ArrayTo" + fieldTypeName + "Array");
                }
                if (typeConverter == null) {
                    typeConverter = (TypeConverter)fieldTypeConverterMap.get(copyBookType + "To" + fieldTypeName);
                }
                if (typeConverter == null) {
                    for (Class<?> aInterface : fieldBaseType.getInterfaces()) {
                        typeConverter = (TypeConverter)fieldTypeConverterMap.get(copyBookType + "To" + aInterface.getSimpleName());
                        if (typeConverter == null) continue;
                        try {
                            typeConverter = typeConverter.copy(type);
                        }
                        catch (IllegalAccessException | InstantiationException e) {
                            throw new CopyBookException("Failed to copy type convert for this field '" + fieldName + "'", e);
                        }
                    }
                }
            } else {
                if (field.getType().isArray()) {
                    typeConverter = (TypeConverter)fieldTypeConverterMap.get("ArrayTo" + fieldTypeName + "Array");
                }
                if (typeConverter == null) {
                    typeConverter = (TypeConverter)fieldTypeConverterMap.get("To" + fieldTypeName);
                }
            }
            if (typeConverter != null) {
                try {
                    typeConverter.validate(fieldBaseType, size, decimals);
                }
                catch (TypeConverterException ex) {
                    throw new CopyBookException(fieldName + ":", ex);
                }
            }
            String name = names.stream().collect(Collectors.joining("."));
            CopyBookField copyBookField = new CopyBookField(type, field, name, size, decimals, minOccurs, maxOccurs, copyBookLines, counterKey, typeConverter);
            copyBookFieldNames.put(name, copyBookField);
            copyBookField.setRedefines(this.getFullFieldName(names, redefines));
            copyBookField.setRedefinedOn(this.getFullFieldName(names, redefineOn));
            copyBookField.setRedefineMatch(redefineMatch);
            if (typeConverter == null) {
                if (fieldBaseType.getAnnotation(CopyBook.class) != null) {
                    copyBookField.setSubCopyBookFields(this.walkClass(fieldBaseType, name, typeConverterMap, charset, strict, copyBookFieldNames));
                } else {
                    if (fieldBaseType.isPrimitive() || fieldBaseType.getName().startsWith("java")) {
                        if (copyBookType != null) throw new CopyBookException("Error mapping field '" + fieldName + "', could not find field converter defined for " + copyBookType + " to " + fieldTypeName);
                        throw new CopyBookException("Error mapping field '" + fieldName + "' as it is not defining a type in the copybook line");
                    }
                    if (copyBookType != null) throw new CopyBookException("CopyBook annotation not found on type for field '" + fieldName + "' or no field converter defined for " + copyBookType + " to " + fieldTypeName);
                    throw new CopyBookException("CopyBook annotation not found on type for field '" + fieldName + "' or no field converter defined for " + fieldTypeName);
                }
            }
            results.add(copyBookField);
        }
        return results;
    }

    private String getTypeClassSimpleName(Class<?> type) {
        switch (type.getName()) {
            case "boolean": {
                return "Boolean";
            }
            case "int": {
                return "Integer";
            }
            case "long": {
                return "Long";
            }
            case "double": {
                return "Double";
            }
            case "bool": {
                return "Bool";
            }
            case "char": {
                return "Char";
            }
            case "byte": {
                return "Byte";
            }
            case "void": {
                return "Void";
            }
        }
        return type.getSimpleName();
    }

    private <T extends Annotation> List<T> getAnnotationsRecursively(Class<?> type, Class<T> annotationType) {
        ArrayList<Annotation> results = new ArrayList<Annotation>();
        for (Annotation annotation : type.getAnnotations()) {
            if (annotationType.isInstance(annotation)) {
                results.add(annotation);
                continue;
            }
            if (annotation.annotationType().getName().startsWith("java")) continue;
            results.addAll(this.getAnnotationsRecursively(annotation.annotationType(), annotationType));
        }
        return results;
    }

    private Map<String, TypeConverter> getTypeConvertersRecursively(Class<?> type, Charset charset, Boolean strict) {
        HashMap<String, TypeConverter> results = new HashMap<String, TypeConverter>();
        for (Annotation annotation : type.getAnnotations()) {
            if (CopyBookFieldFormats.class.isInstance(annotation)) {
                for (CopyBookFieldFormat fieldFormat : ((CopyBookFieldFormats)annotation).value()) {
                    results.put(fieldFormat.type().getSimpleName(), this.createTypeConverter(fieldFormat, charset, strict));
                }
                continue;
            }
            if (CopyBookFieldFormat.class.isInstance(annotation)) {
                CopyBookFieldFormat fieldFormat = (CopyBookFieldFormat)annotation;
                results.put(fieldFormat.type().getSimpleName(), this.createTypeConverter(fieldFormat, charset, strict));
                continue;
            }
            if (annotation.annotationType().getName().startsWith("java")) continue;
            results.putAll(this.getTypeConvertersRecursively(annotation.annotationType(), charset, strict));
        }
        return results;
    }

    private TypeConverter createTypeConverter(CopyBookFieldFormat copyBookFieldFormat, Charset charset, Boolean strict) {
        TypeConverterConfig config = new TypeConverterConfig();
        config.setCharset(charset);
        config.setRightPadding(copyBookFieldFormat.rightPadding());
        config.setNullFillerChar(copyBookFieldFormat.nullFillerChar());
        config.setPaddingChar(copyBookFieldFormat.paddingChar());
        config.setSigningType(copyBookFieldFormat.signingType());
        config.setDefaultValue(copyBookFieldFormat.defaultValue().isEmpty() || strict != false ? null : copyBookFieldFormat.defaultValue());
        config.setFormat(copyBookFieldFormat.format());
        try {
            TypeConverter typeConverter = copyBookFieldFormat.type().newInstance();
            typeConverter.initialize(config);
            return typeConverter;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new CopyBookException("Failed to load TypeConverterBase");
        }
        catch (TypeConverterException e) {
            throw new CopyBookException("Failed to initialize type convert", e);
        }
    }

    private String getFullFieldName(List<String> names, String name) {
        ArrayList<String> baseNames = new ArrayList<String>(names.subList(0, names.size() - 1));
        baseNames.add(name);
        return baseNames.stream().collect(Collectors.joining("."));
    }

    public CopyBookSerializerConfig getConfig() {
        return this.config;
    }

    public void setConfig(CopyBookSerializerConfig config) {
        this.config = config;
    }

    public Class<? extends CopyBookMapper> getSerializerClass() {
        return this.serializerClass;
    }

    public void setSerializerClass(Class<? extends CopyBookMapper> serializerClass) {
        this.serializerClass = serializerClass;
    }
}

