/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.serializers;

import dk.nversion.copybook.exceptions.CopyBookException;
import dk.nversion.copybook.serializers.CopyBookField;
import dk.nversion.copybook.serializers.CopyBookMapperBase;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FullMapper
extends CopyBookMapperBase {
    @Override
    public <T> byte[] serialize(T obj) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[this.maxRecordSize]);
        this.writeFieldsToBuffer(this.fields, buffer, obj);
        byte[] result = new byte[buffer.position()];
        System.arraycopy(buffer.array(), 0, result, 0, buffer.position());
        return result;
    }

    private <T> void writeFieldsToBuffer(List<CopyBookField> fields, ByteBuffer buffer, T rootObj) {
        for (CopyBookField field : fields) {
            if (field.isArray()) {
                int i;
                Object array = field.getObject(rootObj);
                int arraySize = Math.max(array != null ? Array.getLength(array) : 0, field.getMinOccurs());
                if (field.hasSubCopyBookFields()) {
                    for (i = 0; i < arraySize; ++i) {
                        this.writeFieldsToBuffer(field.getSubCopyBookFields(), buffer, field.getObject(rootObj, i));
                    }
                    continue;
                }
                for (i = 0; i < arraySize; ++i) {
                    buffer.put(field.getBytes(rootObj, array, i, true));
                }
                continue;
            }
            if (field.hasSubCopyBookFields()) {
                this.writeFieldsToBuffer(field.getSubCopyBookFields(), buffer, field.getObject(rootObj));
                continue;
            }
            byte[] bytes = field.getBytes(rootObj, true);
            if (bytes != null) {
                buffer.put(bytes);
                continue;
            }
            if (rootObj == null) {
                throw new CopyBookException("Root object for field '" + field.getFieldName() + "' is null and the TypeConverter '" + field.getConverter().getClass().getSimpleName() + "' does not support null filler");
            }
            throw new CopyBookException("TypeConverter " + field.getConverter().getClass().getSimpleName() + " returned null for field " + field.getFieldName());
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> type) {
        try {
            T obj = type.newInstance();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.readFieldsFromBuffer(this.fields, buffer, obj, "", new HashMap<String, Integer>());
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CopyBookException("Failed to create new object", e);
        }
    }

    private void readFieldsFromBuffer(List<CopyBookField> fields, ByteBuffer buffer, Object obj, String name, Map<String, Integer> counters) {
        for (CopyBookField field : fields) {
            String fieldName = name + "." + field.getFieldName();
            if (field.isArray()) {
                int i;
                int arraySize = field.getMaxOccurs();
                if (counters.containsKey(fieldName + "_count")) {
                    arraySize = counters.get(fieldName + "_count");
                } else if (counters.containsKey(field.getCounterKey())) {
                    arraySize = counters.get(field.getCounterKey());
                }
                Object array = field.createArrayObject(obj, arraySize);
                if (field.hasSubCopyBookFields()) {
                    for (i = 0; i < arraySize; ++i) {
                        this.readFieldsFromBuffer(field.getSubCopyBookFields(), buffer, field.createObject(array, i), fieldName, counters);
                    }
                    if (field.getMinOccurs() <= arraySize) continue;
                    int skipSize = (field.getMinOccurs() - arraySize) * field.getRecursiveMinSize() / field.getMinOccurs();
                    buffer.position(buffer.position() + skipSize);
                    continue;
                }
                for (i = 0; i < arraySize; ++i) {
                    field.setBytes(array, i, buffer, true);
                }
                if (field.getMinOccurs() <= arraySize) continue;
                buffer.position(buffer.position() + (field.getMinOccurs() - arraySize) * field.getSize());
                continue;
            }
            if (field.hasSubCopyBookFields()) {
                this.readFieldsFromBuffer(field.getSubCopyBookFields(), buffer, field.createObject(obj), fieldName, counters);
                continue;
            }
            Object value = field.setBytes(obj, buffer, true);
            if (value == null) continue;
            if (field.getField().getType().equals(Integer.TYPE) && fieldName.endsWith("_count")) {
                counters.put(fieldName, (Integer)value);
            }
            if (!field.isCounter()) continue;
            counters.put(field.getName(), (Integer)value);
        }
    }
}

