/*
 * Decompiled with CFR 0.152.
 */
package dk.nversion.copybook.serializers;

import dk.nversion.ByteUtils;
import dk.nversion.copybook.exceptions.CopyBookException;
import dk.nversion.copybook.serializers.CopyBookField;
import dk.nversion.copybook.serializers.CopyBookMapperBase;
import dk.nversion.copybook.serializers.CopyBookSerializerConfig;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class PackedFirstLevelMapper
extends CopyBookMapperBase {
    private int maxBitmapSize;
    private byte separatorByte;
    private int bitmapBlockSize;
    private int packingItemsCount;

    @Override
    public void initialize(CopyBookSerializerConfig config) {
        super.initialize(config);
        this.bitmapBlockSize = 8;
        this.packingItemsCount = this.countPackingItems(config.getFields());
        int maxBitmapBlocks = this.packingItemsCount / (this.bitmapBlockSize * 8 - 1) + 1;
        this.maxBitmapSize = this.bitmapBlockSize * maxBitmapBlocks;
        this.separatorByte = (byte)11;
    }

    private int countPackingItems(List<CopyBookField> fields) {
        int count = 0;
        for (CopyBookField field : fields) {
            if (field.isArray()) {
                count += field.getMaxOccurs();
                continue;
            }
            ++count;
        }
        return count;
    }

    @Override
    public <T> byte[] serialize(T obj) {
        PackedBuffer buffer = new PackedBuffer(this.maxRecordSize + this.packingItemsCount, this.maxBitmapSize, this.bitmapBlockSize, this.separatorByte);
        this.writeFields(buffer, this.fields, obj, true);
        return buffer.array();
    }

    private void writeFields(PackedBuffer buffer, List<CopyBookField> fields, Object rootObj, boolean rootLast) {
        for (CopyBookField field : fields) {
            boolean last;
            boolean bl = last = rootLast && field.isLast();
            if (field.isArray()) {
                int j;
                Object array = field.getObject(rootObj);
                if (field.hasSubCopyBookFields()) {
                    Object item;
                    if (field.getLevel() == 0) {
                        for (j = 0; j < field.getMinOccurs(); ++j) {
                            Object object = item = array != null ? field.getObject(rootObj, array, j) : null;
                            if (item != null) {
                                this.writeFields(buffer, field.getSubCopyBookFields(), item, true);
                                continue;
                            }
                            buffer.put(null, true);
                        }
                        continue;
                    }
                    for (j = 0; j < field.getMinOccurs(); ++j) {
                        item = array != null ? field.getObject(rootObj, array, j) : null;
                        this.writeFields(buffer, field.getSubCopyBookFields(), item, last && field.getMinOccurs() - 1 == j);
                    }
                    continue;
                }
                for (j = 0; j < field.getMinOccurs(); ++j) {
                    this.writeField(buffer, field, field.getObject(rootObj, array, j), last && field.getMinOccurs() - 1 == j);
                }
                continue;
            }
            if (field.hasSubCopyBookFields()) {
                Object item = field.getObject(rootObj);
                if (field.getLevel() == 0) {
                    if (item != null) {
                        this.writeFields(buffer, field.getSubCopyBookFields(), item, true);
                        continue;
                    }
                    buffer.put(null, true);
                    continue;
                }
                this.writeFields(buffer, fields, item, last);
                continue;
            }
            this.writeField(buffer, field, field.getObject(rootObj), last);
        }
    }

    private void writeField(PackedBuffer buffer, CopyBookField field, Object valueObj, boolean last) {
        if (field.getLevel() == 0) {
            buffer.put(field.getBytes(null, valueObj, false), true);
        } else if (last) {
            byte[] valueBytes = field.getBytes(null, valueObj, false);
            if (valueBytes == null) {
                valueBytes = field.getBytes(null, valueObj, true);
            }
            buffer.put(valueBytes, true);
        } else {
            buffer.put(field.getBytes(null, valueObj, true), false);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> type) {
        try {
            T obj = type.newInstance();
            PackedBuffer buffer = new PackedBuffer(bytes, this.maxBitmapSize, this.bitmapBlockSize, this.separatorByte);
            this.readFields(this.fields, buffer, obj, true);
            return obj;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CopyBookException("Failed to create new object", e);
        }
    }

    private void readFields(List<CopyBookField> fields, PackedBuffer buffer, Object obj, boolean rootLast) {
        for (CopyBookField field : fields) {
            boolean last;
            boolean bl = last = rootLast && field.isLast();
            if (this.debug) {
                System.out.println("read " + field.getFieldName());
            }
            if (field.isArray()) {
                int i;
                int arraySize = field.getLevel() == 0 ? buffer.getArraySize(field.getMinOccurs()) : field.getMinOccurs();
                Object array = field.createArrayObject(obj, arraySize);
                if (field.hasSubCopyBookFields()) {
                    int j;
                    if (field.getLevel() == 0) {
                        for (j = 0; j < arraySize; ++j) {
                            this.readFields(field.getSubCopyBookFields(), buffer, field.createObject(array, j), true);
                        }
                        buffer.incBitmapIndex(field.getMinOccurs() - arraySize);
                        continue;
                    }
                    for (j = 0; j < arraySize; ++j) {
                        this.readFields(field.getSubCopyBookFields(), buffer, field.createObject(array, j), last && field.getMinOccurs() - 1 == j);
                    }
                    continue;
                }
                if (field.getLevel() == 0) {
                    for (i = 0; i < arraySize; ++i) {
                        field.setBytes(array, i, buffer.get(field.getSize(), true), false);
                    }
                    buffer.incBitmapIndex(field.getMinOccurs() - arraySize);
                    continue;
                }
                for (i = 0; i < arraySize; ++i) {
                    boolean isLast = last && field.getMinOccurs() - 1 == i;
                    field.setBytes(array, i, buffer.get(field.getSize(), isLast), !isLast);
                }
                continue;
            }
            if (field.hasSubCopyBookFields()) {
                this.readFields(field.getSubCopyBookFields(), buffer, field.createObject(obj), field.getLevel() == 0 || last);
                continue;
            }
            if (field.getLevel() == 0 || last) {
                field.setBytes(obj, buffer.get(field.getSize(), true), false);
                continue;
            }
            field.setBytes(obj, buffer.get(field.getSize(), false), true);
        }
    }

    private class PackedBuffer {
        private ByteBuffer buffer;
        private byte[] bitmapBytes;
        private int bitmapIndex = 0;
        private int maxUsedBit = 0;
        private int bitmapBlockSize;
        private byte separatorByte;
        private int bitmapSize;
        private int bitmapMaxSize;

        public PackedBuffer(int size, int bitmapMaxSize, int bitmapBlockSize, byte separatorByte) {
            this.buffer = ByteBuffer.wrap(new byte[size]);
            this.bitmapBytes = new byte[bitmapMaxSize];
            this.bitmapBlockSize = bitmapBlockSize;
            this.separatorByte = separatorByte;
        }

        public PackedBuffer(byte[] bytes, int bitmapMaxSize, int bitmapBlockSize, byte separatorByte) {
            this.buffer = ByteBuffer.wrap(bytes);
            this.bitmapBlockSize = bitmapBlockSize;
            this.separatorByte = separatorByte;
            this.bitmapMaxSize = bitmapMaxSize;
            this.bitmapSize = this.getBitMapSize(bytes);
            this.bitmapBytes = new byte[this.bitmapSize];
            this.buffer.get(this.bitmapBytes);
        }

        public int getArraySize(int maxOccurs) {
            int size = 0;
            for (int i = 0; i < maxOccurs; ++i) {
                if (this.getBitInBitmap(this.bitmapBytes, this.bitmapIndex + i, this.bitmapSize)) {
                    size = i + 1;
                    if (!PackedFirstLevelMapper.this.debug) continue;
                    System.out.print("+");
                    continue;
                }
                if (!PackedFirstLevelMapper.this.debug) continue;
                System.out.print("-");
            }
            if (PackedFirstLevelMapper.this.debug) {
                System.out.println(size);
            }
            return size;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public byte[] get(int maxLength, boolean separator) {
            byte[] byteValue = null;
            if (this.getBitInBitmap(this.bitmapBytes, this.bitmapIndex, this.bitmapSize)) {
                if (separator) {
                    int index = ByteUtils.indexOf(this.buffer.array(), this.separatorByte, this.buffer.position() + 1, maxLength);
                    if (index <= 0) throw new CopyBookException("Could not find expected separator in response at index " + this.buffer.position());
                    byteValue = new byte[index - this.buffer.position()];
                    this.buffer.get(byteValue);
                    this.buffer.position(this.buffer.position() + 1);
                } else {
                    byteValue = new byte[maxLength];
                    this.buffer.get(byteValue);
                }
            }
            if (!separator) return byteValue;
            ++this.bitmapIndex;
            return byteValue;
        }

        public void put(byte[] bytes, boolean separator) {
            if (bytes != null) {
                if (ByteUtils.indexOf(bytes, this.separatorByte, 0, bytes.length) > -1) {
                    throw new CopyBookException("Bytes contains the separator char");
                }
                this.buffer.put(bytes);
                if (PackedFirstLevelMapper.this.debug) {
                    System.out.print("'" + new String(bytes, StandardCharsets.UTF_8) + "'");
                }
                if (separator) {
                    if (PackedFirstLevelMapper.this.debug) {
                        System.out.println("[]");
                    }
                    this.setBitInBitmap();
                    this.maxUsedBit = this.bitmapIndex;
                    this.buffer.put(this.separatorByte);
                }
            }
            if (separator) {
                if (PackedFirstLevelMapper.this.debug) {
                    System.out.println("((");
                }
                ++this.bitmapIndex;
                if (PackedFirstLevelMapper.this.debug) {
                    System.out.println(this.debugBitmap(this.bitmapBytes, 0, 8));
                }
            }
        }

        public byte[] array() {
            int bitmapBlocks = this.maxUsedBit / (this.bitmapBlockSize * 8 - 1) + 1;
            int bitmapSize = bitmapBlocks * this.bitmapBlockSize;
            for (int i = 0; i < bitmapSize / this.bitmapBlockSize - 1; ++i) {
                this.bitmapBytes[i * this.bitmapBlockSize + (this.bitmapBlockSize - 1)] = (byte)(this.bitmapBytes[i * this.bitmapBlockSize + (this.bitmapBlockSize - 1)] | 1);
            }
            byte[] result = new byte[this.buffer.position() + bitmapSize];
            System.arraycopy(this.bitmapBytes, 0, result, 0, bitmapSize);
            System.arraycopy(this.buffer.array(), 0, result, bitmapSize, this.buffer.position());
            return result;
        }

        public void incBitmapIndex() {
            ++this.bitmapIndex;
        }

        public void incBitmapIndex(int i) {
            this.bitmapIndex += i;
        }

        private void setBitInBitmap() {
            int bitOffset = this.bitmapIndex / (this.bitmapBlockSize * 8 - 1) + this.bitmapIndex;
            this.bitmapBytes[bitOffset / this.bitmapBlockSize] = (byte)(this.bitmapBytes[bitOffset / this.bitmapBlockSize] | 128 >> bitOffset % 8);
        }

        private boolean getBitInBitmap(byte[] bytes, int bitIndex, int bitmapSize) {
            if ((bitIndex += bitIndex / 63) < bitmapSize * 8) {
                return (bytes[bitIndex / this.bitmapBlockSize] & 128 >> bitIndex % this.bitmapBlockSize) != 0;
            }
            return false;
        }

        private int getBitMapSize(byte[] data) {
            int e = 1;
            while ((data[e * 8 - 1] & 1) != 0) {
                ++e;
            }
            int bitMapSize = e * this.bitmapBlockSize;
            if (bitMapSize > this.bitmapMaxSize) {
                throw new CopyBookException("Bitmap is to large for this copybook");
            }
            return bitMapSize;
        }

        private String debugBitmap(byte[] bytes, int index, int length) {
            String result = "";
            for (int i = index; i < length; ++i) {
                result = result + ("0000000" + Integer.toBinaryString(bytes[i] & 0xFF)).replaceAll(".*(.{8})$", "$1");
            }
            return result;
        }
    }
}

