/*
 * Decompiled with CFR 0.152.
 */
package dk.nykredit.swagger;

import dk.nykredit.swagger.JaxRSScanner;
import dk.nykredit.swagger.OutputFormat;
import dk.nykredit.swagger.config.SwaggerConfig;
import io.swagger.jaxrs.Reader;
import io.swagger.models.Swagger;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="generate", defaultPhase=LifecyclePhase.PREPARE_PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class GenerateMojo
extends AbstractMojo {
    @Parameter
    private SwaggerConfig swaggerConfig;
    @Parameter
    private Set<String> resourcePackages;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;
    @Parameter
    private Set<OutputFormat> outputFormats = Collections.singleton(OutputFormat.JSON);
    @Parameter(defaultValue="false")
    private boolean attachSwaggerArtifact;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Reader reader = new Reader(this.swaggerConfig == null ? new Swagger() : this.swaggerConfig.createSwaggerModel());
        JaxRSScanner reflectiveScanner = new JaxRSScanner();
        if (this.resourcePackages != null && !this.resourcePackages.isEmpty()) {
            reflectiveScanner.setResourcePackages(this.resourcePackages);
        }
        Swagger swagger = reader.read(reflectiveScanner.classes());
        if (this.outputDirectory.mkdirs()) {
            this.getLog().debug((CharSequence)("Created output directory " + this.outputDirectory));
        }
        this.outputFormats.forEach(format -> {
            try {
                File outputFile = new File(this.outputDirectory, "swagger." + format.name().toLowerCase());
                format.write(swagger, outputFile);
                if (this.attachSwaggerArtifact) {
                    this.projectHelper.attachArtifact(this.project, format.name().toLowerCase(), "swagger", outputFile);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unable write Swagger document", e);
            }
        });
    }
}

