/*
 * Decompiled with CFR 0.152.
 */
package dk.nykredit.swagger;

import io.swagger.annotations.Api;
import io.swagger.annotations.SwaggerDefinition;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ConfigurationBuilder;

class JaxRSScanner
implements io.swagger.config.Scanner {
    private boolean prettyPrint;
    private Set<String> resourcePackages = Collections.emptySet();

    JaxRSScanner() {
    }

    public Set<Class<?>> classes() {
        ConfigurationBuilder config = ConfigurationBuilder.build((Object[])new Object[]{this.resourcePackages});
        config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        Set apiClasses = reflections.getTypesAnnotatedWith(Api.class);
        Stream<Class> filteredApiStrem = apiClasses.stream().filter(cls -> this.resourcePackages.isEmpty() || this.resourcePackages.contains(cls.getPackage().getName()));
        Set defClasses = reflections.getTypesAnnotatedWith(SwaggerDefinition.class);
        Stream<Class> filteredDefStream = defClasses.stream().filter(cls -> this.resourcePackages.isEmpty() || this.resourcePackages.contains(cls.getPackage().getName()));
        return Stream.concat(filteredApiStrem, filteredDefStream).collect(Collectors.toSet());
    }

    public boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean shouldPrettyPrint) {
        this.prettyPrint = shouldPrettyPrint;
    }

    void setResourcePackages(Set<String> resourcePackages) {
        this.resourcePackages = new HashSet<String>(resourcePackages);
    }
}

