/*
 * Decompiled with CFR 0.152.
 */
package dk.nykredit.swagger.config;

import dk.nykredit.swagger.config.SwaggerInfo;
import io.swagger.models.Info;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.maven.plugins.annotations.Parameter;

public class SwaggerConfig {
    @Parameter
    private String schemes;
    @Parameter
    private String host;
    @Parameter
    private String basePath;
    @Parameter
    private SwaggerInfo info;
    @Parameter
    private File descriptionFile;

    public Swagger createSwaggerModel() {
        Swagger swagger = new Swagger();
        if (this.schemes != null) {
            Arrays.stream(this.schemes.split(",")).forEach(scheme -> swagger.scheme(Scheme.forValue((String)scheme)));
        }
        if (this.host != null) {
            swagger.setHost(this.host);
        }
        if (this.basePath != null) {
            swagger.setBasePath(this.basePath);
        }
        if (this.info != null) {
            swagger.setInfo(this.info.createInfoModel());
        }
        if (this.descriptionFile != null) {
            if (swagger.getInfo() == null) {
                swagger.setInfo(new Info());
            }
            try {
                swagger.getInfo().setDescription(Files.readAllLines(this.descriptionFile.toPath()).stream().collect(Collectors.joining("\n")));
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to read descriptor file " + this.descriptionFile, e);
            }
        }
        return swagger;
    }
}

