/*
 * Decompiled with CFR 0.152.
 */
package dk.schaumburgit.stillsequencecamera.camera;

import android.app.Activity;
import android.hardware.Camera;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import dk.schaumburgit.stillsequencecamera.IStillSequenceCamera;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class StillSequenceCamera
implements IStillSequenceCamera {
    private static final String TAG = "StillSequenceCamera";
    private final int mCameraId;
    private Camera mCamera;
    private final Activity mActivity;
    private final int mMinPixels;
    private final SurfaceView mPreview;
    private IStillSequenceCamera.OnImageAvailableListener mImageListener = null;
    private Handler mCallbackHandler;
    private static final int CLOSED = 0;
    private static final int INITIALIZED = 1;
    private static final int CAPTURING = 2;
    private boolean mLockFocus = true;
    private int mState = 0;
    private boolean mContinueTakingPictures = false;

    public StillSequenceCamera(Activity activity, SurfaceView preview, int minPixels) {
        this.mActivity = activity;
        this.mPreview = preview;
        this.mState = 0;
        if (minPixels < 786432) {
            minPixels = 786432;
        }
        this.mMinPixels = minPixels;
        int chosenCameraId = -1;
        int numberOfCameras = Camera.getNumberOfCameras();
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
            if (info.facing != 0) continue;
            chosenCameraId = i;
            break;
        }
        if (chosenCameraId < 0) {
            throw new UnsupportedOperationException("Cannot find a back-facing camera");
        }
        this.mCameraId = chosenCameraId;
        this.mCamera = Camera.open((int)this.mCameraId);
    }

    @Override
    public Map<Integer, Double> getSupportedImageFormats() {
        HashMap<Integer, Double> res = new HashMap<Integer, Double>();
        Iterator iterator = this.mCamera.getParameters().getSupportedPictureFormats().iterator();
        while (iterator.hasNext()) {
            int format = (Integer)iterator.next();
            res.put(format, StillSequenceCamera.getFormatCost(format));
            Log.i((String)TAG, (String)("CAMERA FORMAT: " + format));
        }
        return res;
    }

    private static double getFormatCost(int format) {
        switch (format) {
            case 0: {
                return 1.0;
            }
            case 17: {
                return 0.8;
            }
            case 16: {
                return 0.8;
            }
            case 20: 
            case 35: 
            case 842094169: {
                return 0.5;
            }
            case 39: {
                return 0.5;
            }
            case 40: {
                return 0.5;
            }
            case 4: 
            case 41: 
            case 42: {
                return 0.8;
            }
            case 256: {
                return 1.0;
            }
            case 32: 
            case 37: 
            case 38: {
                return 0.4;
            }
            case 257: 
            case 1144402265: {
                return 1.5;
            }
        }
        return 1.0;
    }

    @Override
    public void setup(int format) throws UnsupportedOperationException, IllegalStateException {
        if (this.mState != 0) {
            throw new IllegalStateException("StillSequenceCamera.setup() can only be called on a new instance");
        }
        Camera.Parameters pars = this.mCamera.getParameters();
        pars.setPictureFormat(format);
        pars.setFocusMode("continuous-picture");
        List choices = pars.getSupportedPictureSizes();
        ArrayList<Camera.Size> bigEnough = new ArrayList<Camera.Size>();
        for (Camera.Size option : choices) {
            if (option.width * option.height < this.mMinPixels) continue;
            bigEnough.add(option);
        }
        Camera.Size captureSize = null;
        captureSize = bigEnough.isEmpty() ? Collections.max(choices, new CompareSizesByArea()) : Collections.min(bigEnough, new CompareSizesByArea());
        pars.setPictureSize(captureSize.width, captureSize.height);
        this.mCamera.setParameters(pars);
        this.mState = 1;
    }

    @Override
    public void start(IStillSequenceCamera.OnImageAvailableListener listener, Handler callbackHandler) throws IllegalStateException {
        if (this.mState != 1) {
            throw new IllegalStateException("StillSequenceCamera.start() can only be called in the INITIALIZED state");
        }
        this.mImageListener = listener;
        this.mCallbackHandler = callbackHandler;
        if (this.mCallbackHandler == null) {
            this.mCallbackHandler = new Handler();
        }
        if (this.mPreview.getHolder().getSurface() != null) {
            try {
                this.mCamera.setPreviewDisplay(this.mPreview.getHolder());
                this.mCamera.startPreview();
                this.startTakingPictures();
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)("Error setting camera preview: " + e.getMessage()));
            }
        }
        this.mPreview.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                try {
                    if (StillSequenceCamera.this.mCamera != null) {
                        StillSequenceCamera.this.mCamera.setPreviewDisplay(holder);
                        StillSequenceCamera.this.mCamera.startPreview();
                        StillSequenceCamera.this.startTakingPictures();
                    }
                }
                catch (IOException e) {
                    Log.d((String)StillSequenceCamera.TAG, (String)("Error setting camera preview: " + e.getMessage()));
                }
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
                try {
                    StillSequenceCamera.this.mCamera.stopPreview();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    StillSequenceCamera.this.mCamera.setPreviewDisplay(StillSequenceCamera.this.mPreview.getHolder());
                    StillSequenceCamera.this.mCamera.startPreview();
                }
                catch (Exception e) {
                    Log.d((String)StillSequenceCamera.TAG, (String)("Error re-starting camera preview: " + e.getMessage()));
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                try {
                    StillSequenceCamera.this.stopTakingPictures();
                    StillSequenceCamera.this.mCamera.stopPreview();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.mPreview.getHolder().setType(3);
        this.mState = 2;
    }

    @Override
    public void stop() throws IllegalStateException {
        if (this.mState == 0) {
            return;
        }
        if (this.mState != 2) {
            throw new IllegalStateException("StillSequenceCamera.stop() can only be called in the STARTED state");
        }
        this.mImageListener = null;
        this.mCallbackHandler = null;
        this.stopTakingPictures();
        try {
            this.mCamera.stopPreview();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mState = 1;
    }

    @Override
    public void close() {
        if (this.mState == 0) {
            return;
        }
        if (this.mState == 2) {
            this.stop();
        }
        if (this.mState != 1) {
            throw new IllegalStateException("StillSequenceCamera.stop() can only be called after start()");
        }
        this.mContinueTakingPictures = false;
        if (this.mCamera != null) {
            this.mCamera.release();
            this.mCamera = null;
        }
        this.mImageListener = null;
        this.mState = 0;
    }

    private void startTakingPictures() throws IllegalStateException {
        if (this.mContinueTakingPictures) {
            return;
        }
        if (this.mCameraId < 0) {
            throw new IllegalStateException("StillSequenceCamera.start() cannot be called before setup()");
        }
        this.mContinueTakingPictures = true;
        this.takePicture();
    }

    private void stopTakingPictures() {
        this.mContinueTakingPictures = false;
    }

    private void takePicture() {
        this.mCamera.takePicture(null, null, new Camera.PictureCallback(){

            public void onPictureTaken(final byte[] jpegData, Camera camera) {
                final Camera.Size size = camera.getParameters().getPictureSize();
                Log.i((String)StillSequenceCamera.TAG, (String)("Captured JPEG " + jpegData.length + " bytes (" + size.width + "x" + size.height + ")"));
                if (StillSequenceCamera.this.mImageListener != null) {
                    StillSequenceCamera.this.mCallbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            StillSequenceCamera.this.mImageListener.onJpegImageAvailable(jpegData, size.width, size.height);
                        }
                    });
                }
                if (StillSequenceCamera.this.mContinueTakingPictures) {
                    StillSequenceCamera.this.mCamera.startPreview();
                    StillSequenceCamera.this.takePicture();
                }
            }
        });
    }

    @Override
    public boolean isLockFocus() {
        return this.mLockFocus;
    }

    @Override
    public void setLockFocus(boolean lockFocus) {
        this.mLockFocus = lockFocus;
    }

    static class CompareSizesByArea
    implements Comparator<Camera.Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Camera.Size lhs, Camera.Size rhs) {
            return Long.signum((long)lhs.width * (long)lhs.height - (long)rhs.width * (long)rhs.height);
        }
    }
}

