/*
 * Decompiled with CFR 0.152.
 */
package dk.schaumburgit.stillsequencecamera.camera2;

import android.app.Activity;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.util.SparseIntArray;
import android.view.Surface;
import dk.schaumburgit.stillsequencecamera.IStillSequenceCamera;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CaptureManager {
    private static final String TAG = "StillSequenceCamera2";
    private final Activity mActivity;
    private final int mMinPixels;
    private ImageReader mImageReader;
    private IStillSequenceCamera.OnImageAvailableListener mImageListener = null;
    private CameraCaptureSession mCameraCaptureSession;
    private CaptureRequest mStillCaptureRequest = null;
    private HandlerThread mInternalCaptureThread;
    private Handler mInternalCaptureHandler;
    private static final SparseIntArray ORIENTATIONS = new SparseIntArray();

    public CaptureManager(Activity activity, int minPixels) {
        if (activity == null) {
            throw new NullPointerException("CaptureManager requires an Activity");
        }
        this.mActivity = activity;
        if (minPixels < 786432) {
            minPixels = 786432;
        }
        this.mMinPixels = minPixels;
    }

    public Map<Integer, Double> getSupportedImageFormats(String cameraId) {
        try {
            CameraManager manager = (CameraManager)this.mActivity.getSystemService("camera");
            StreamConfigurationMap map = (StreamConfigurationMap)manager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (map == null) {
                throw new UnsupportedOperationException("Insufficient camera info available");
            }
            HashMap<Integer, Double> res = new HashMap<Integer, Double>();
            for (int format : map.getOutputFormats()) {
                res.put(format, CaptureManager.getFormatCost(format));
                Log.i((String)TAG, (String)("CAMERA FORMAT: " + format));
            }
            return res;
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"Camera2 API is not supported");
            throw new UnsupportedOperationException("Camera2 API is not supported");
        }
        return null;
    }

    private static double getFormatCost(int format) {
        switch (format) {
            case 0: {
                return 1.0;
            }
            case 17: {
                return 0.7;
            }
            case 16: {
                return 0.8;
            }
            case 842094169: {
                return 0.8;
            }
            case 20: {
                return 0.8;
            }
            case 35: {
                return 0.71;
            }
            case 39: {
                return 0.71;
            }
            case 40: {
                return 0.71;
            }
            case 4: 
            case 41: 
            case 42: {
                return 0.8;
            }
            case 256: {
                return 1.0;
            }
            case 32: {
                return 2.02;
            }
            case 37: {
                return 0.66;
            }
            case 38: {
                return 0.66;
            }
            case 257: 
            case 1144402265: {
                return 2.5;
            }
        }
        return 1.0;
    }

    public void setup(String cameraId, int imageFormat) {
        try {
            CameraManager manager = (CameraManager)this.mActivity.getSystemService("camera");
            StreamConfigurationMap map = (StreamConfigurationMap)manager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (map == null) {
                throw new UnsupportedOperationException("Insufficient camera info available");
            }
            if (!map.isOutputSupportedFor(imageFormat)) {
                throw new UnsupportedOperationException("Camera cannot capture images in format " + imageFormat);
            }
            int outputFormat = imageFormat;
            List<Size> choices = Arrays.asList(map.getOutputSizes(outputFormat));
            ArrayList<Size> bigEnough = new ArrayList<Size>();
            for (Size option : choices) {
                if (option.getWidth() * option.getHeight() < this.mMinPixels) continue;
                bigEnough.add(option);
            }
            Size captureSize = null;
            captureSize = bigEnough.isEmpty() ? Collections.max(choices, new CompareSizesByArea()) : Collections.min(bigEnough, new CompareSizesByArea());
            this.mImageReader = ImageReader.newInstance((int)captureSize.getWidth(), (int)captureSize.getHeight(), (int)outputFormat, (int)4);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"Camera2 API is not supported");
            throw new UnsupportedOperationException("Camera2 API is not supported");
        }
    }

    public Surface getSurface() {
        if (this.mImageReader == null) {
            throw new IllegalStateException("CaptureManager.getSurface() cannot be called before setup() has completed");
        }
        return this.mImageReader.getSurface();
    }

    public void start(CameraCaptureSession cameraCaptureSession, final Handler callbackHandler, final IStillSequenceCamera.OnImageAvailableListener listener) {
        if (this.mImageReader == null) {
            throw new IllegalStateException("CaptureManager: start() may only be called after setup() and before close()");
        }
        if (null == cameraCaptureSession) {
            return;
        }
        this.mCameraCaptureSession = cameraCaptureSession;
        this.mImageListener = listener;
        CameraDevice cameraDevice = cameraCaptureSession.getDevice();
        if (null == cameraDevice) {
            return;
        }
        this.mInternalCaptureThread = new HandlerThread("Camera Image Capture Background");
        this.mInternalCaptureThread.start();
        this.mInternalCaptureHandler = new Handler(this.mInternalCaptureThread.getLooper());
        this.mImageReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){
            private Image mLatestImage = null;

            public void onImageAvailable(ImageReader reader) {
                Image image = reader.acquireLatestImage();
                if (image != null) {
                    this.sendImageAvailable(image);
                }
            }

            private synchronized Image getLatestImage() {
                Image image = this.mLatestImage;
                this.mLatestImage = null;
                return image;
            }

            private synchronized void setLatestImage(Image image) {
                if (this.mLatestImage != null) {
                    this.mLatestImage.close();
                }
                this.mLatestImage = image;
            }

            private void sendImageAvailable(Image image) {
                this.setLatestImage(image);
                if (listener == null) {
                    image.close();
                    return;
                }
                if (image == null) {
                    return;
                }
                callbackHandler.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Image image = this.getLatestImage();
                        if (image == null) {
                            return;
                        }
                        IStillSequenceCamera.OnImageAvailableListener listener = CaptureManager.this.mImageListener;
                        if (listener == null) {
                            image.close();
                            return;
                        }
                        try {
                            listener.onImageAvailable(image);
                        }
                        catch (Exception e) {
                            Log.e((String)CaptureManager.TAG, (String)"Error extracting image", (Throwable)e);
                        }
                        finally {
                            image.close();
                        }
                    }
                });
            }
        }, this.mInternalCaptureHandler);
        try {
            CaptureRequest.Builder captureBuilder = cameraDevice.createCaptureRequest(2);
            captureBuilder.addTarget(this.mImageReader.getSurface());
            captureBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            captureBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
            int rotation = this.mActivity.getWindowManager().getDefaultDisplay().getRotation();
            captureBuilder.set(CaptureRequest.JPEG_ORIENTATION, (Object)ORIENTATIONS.get(rotation));
            this.mStillCaptureRequest = captureBuilder.build();
            this.mCameraCaptureSession.setRepeatingRequest(this.mStillCaptureRequest, new CameraCaptureSession.CaptureCallback(){

                public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
                    super.onCaptureSequenceCompleted(session, sequenceId, frameNumber);
                    if (CaptureManager.this.mInternalCaptureThread != null) {
                        Log.i((String)CaptureManager.TAG, (String)"Killed capture thread");
                        try {
                            CaptureManager.this.mInternalCaptureHandler.removeCallbacksAndMessages(null);
                            CaptureManager.this.mInternalCaptureThread.quitSafely();
                            CaptureManager.this.mInternalCaptureThread.join();
                            CaptureManager.this.mInternalCaptureThread = null;
                            CaptureManager.this.mInternalCaptureHandler = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, this.mInternalCaptureHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        this.mImageListener = null;
        if (null != this.mImageReader) {
            this.mImageReader.setOnImageAvailableListener(null, null);
        }
        this.mStillCaptureRequest = null;
        this.mCameraCaptureSession = null;
    }

    public void close() {
        if (this.mImageReader != null) {
            this.mImageReader.setOnImageAvailableListener(null, null);
            this.mImageReader.close();
            this.mImageReader = null;
        }
    }

    private void captureNext() {
        if (this.mCameraCaptureSession == null) {
            return;
        }
        try {
            this.mCameraCaptureSession.capture(this.mStillCaptureRequest, null, null);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
    }

    static {
        ORIENTATIONS.append(0, 90);
        ORIENTATIONS.append(1, 0);
        ORIENTATIONS.append(2, 270);
        ORIENTATIONS.append(3, 180);
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }
}

