/*
 * Decompiled with CFR 0.152.
 */
package dk.schaumburgit.stillsequencecamera.camera2;

import android.app.Activity;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.TotalCaptureResult;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.util.Size;
import android.view.Surface;
import android.view.TextureView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class FocusManager {
    private static final String TAG = "FocusManager";
    private final Activity mActivity;
    private TextureView mTextureView;
    private Size mPreviewSize;
    private ImageReader mPreviewImageReader;
    private FocusingStateMachine mStateMachine;
    private Surface mPreviewSurface = null;
    private CameraCaptureSession mCameraCaptureSession;

    public FocusManager(Activity activity, TextureView textureView) {
        this.mActivity = activity;
        this.mTextureView = textureView;
    }

    public void setup(String cameraId) {
        try {
            CameraManager manager = (CameraManager)this.mActivity.getSystemService("camera");
            StreamConfigurationMap map = (StreamConfigurationMap)manager.getCameraCharacteristics(cameraId).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
            if (map == null) {
                throw new UnsupportedOperationException("Insufficient camera info available");
            }
            if (this.mTextureView != null) {
                this.mPreviewSize = FocusManager.chooseOptimalSize(map.getOutputSizes(SurfaceTexture.class), this.mTextureView.getWidth(), this.mTextureView.getHeight());
                int orientation = this.mActivity.getResources().getConfiguration().orientation;
                if (orientation == 2) {
                    // empty if block
                }
                this.mTextureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

                    public void onSurfaceTextureAvailable(SurfaceTexture texture, int width, int height) {
                    }

                    public void onSurfaceTextureSizeChanged(SurfaceTexture texture, int width, int height) {
                        FocusManager.this.configureTransform();
                    }

                    public boolean onSurfaceTextureDestroyed(SurfaceTexture texture) {
                        return true;
                    }

                    public void onSurfaceTextureUpdated(SurfaceTexture texture) {
                    }
                });
                if (this.mTextureView.isAvailable()) {
                    this.configureTransform();
                }
            } else {
                this.mPreviewImageReader = ImageReader.newInstance((int)320, (int)240, (int)35, (int)2);
                this.mPreviewImageReader.setOnImageAvailableListener(new ImageReader.OnImageAvailableListener(){

                    public void onImageAvailable(ImageReader reader) {
                        Image image = reader.acquireLatestImage();
                        if (image != null) {
                            image.close();
                        }
                    }
                }, null);
                this.mPreviewSurface = this.mPreviewImageReader.getSurface();
            }
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"Camera2 API is not supported");
            throw new UnsupportedOperationException("Camera2 API is not supported");
        }
        catch (Exception e) {
            if (this.mPreviewImageReader != null) {
                this.mPreviewImageReader.setOnImageAvailableListener(null, null);
                this.mPreviewImageReader = null;
            }
            if (this.mPreviewSurface != null) {
                this.mPreviewSurface.release();
                this.mPreviewSurface = null;
            }
            e.printStackTrace();
        }
    }

    public void close() {
        if (this.mTextureView != null) {
            this.mTextureView.setSurfaceTextureListener(null);
        }
        if (this.mPreviewImageReader != null) {
            this.mPreviewImageReader.setOnImageAvailableListener(null, null);
        }
    }

    private static Size chooseOptimalSize(Size[] choices, int width, int height) {
        ArrayList<Size> bigEnough = new ArrayList<Size>();
        int w = width;
        int h = height;
        for (Size option : choices) {
            if (option.getHeight() != option.getWidth() * h / w || option.getWidth() < width || option.getHeight() < height) continue;
            bigEnough.add(option);
        }
        if (bigEnough.size() > 0) {
            return Collections.min(bigEnough, new CompareSizesByArea());
        }
        Log.e((String)TAG, (String)"Couldn't find any suitable preview size");
        return choices[0];
    }

    private void configureTransform() {
        if (null == this.mTextureView || null == this.mPreviewSize) {
            return;
        }
        int viewWidth = this.mTextureView.getWidth();
        int viewHeight = this.mTextureView.getHeight();
        int rotation = this.mActivity.getWindowManager().getDefaultDisplay().getRotation();
        Matrix matrix = new Matrix();
        RectF viewRect = new RectF(0.0f, 0.0f, (float)viewWidth, (float)viewHeight);
        RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.mPreviewSize.getHeight(), (float)this.mPreviewSize.getWidth());
        float centerX = viewRect.centerX();
        float centerY = viewRect.centerY();
        if (1 == rotation || 3 == rotation) {
            bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
            matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
            float scale = Math.max((float)viewHeight / (float)this.mPreviewSize.getHeight(), (float)viewWidth / (float)this.mPreviewSize.getWidth());
            matrix.postScale(scale, scale, centerX, centerY);
            matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
        } else if (2 == rotation) {
            matrix.postRotate(180.0f, centerX, centerY);
        }
        this.mTextureView.setTransform(matrix);
        if (this.mPreviewSurface == null) {
            SurfaceTexture texture = this.mTextureView.getSurfaceTexture();
            assert (texture != null);
            texture.setDefaultBufferSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
            this.mPreviewSurface = new Surface(texture);
        }
    }

    public Surface getSurface() {
        return this.mPreviewSurface;
    }

    public void start(CameraCaptureSession cameraCaptureSession, boolean lockFocus, Handler callbackHandler, FocusListener listener) {
        this.mCameraCaptureSession = cameraCaptureSession;
        try {
            Log.i((String)TAG, (String)"StartFocusing");
            this.mStateMachine = new FocusingStateMachine(cameraCaptureSession, lockFocus, callbackHandler, listener);
            this.mStateMachine.start(this.mPreviewSurface);
        }
        catch (Exception e) {
            if (cameraCaptureSession != null) {
                this.stop();
            }
            this.mPreviewImageReader = null;
            e.printStackTrace();
        }
    }

    public void stop() {
        if (this.mStateMachine == null) {
            return;
        }
        try {
            this.mStateMachine.close();
            this.mStateMachine = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class FocusingStateMachine
    extends CameraCaptureSession.CaptureCallback {
        private final FocusListener mListener;
        private final Handler mCallbackHandler;
        private final CameraCaptureSession mCaptureSession;
        private final boolean mLockFocus;
        private HandlerThread mFocusingStateMachineThread;
        private Handler mFocusingStateMachineHandler;
        private CaptureRequest.Builder mPreviewRequestBuilder;
        private static final int STATE_IDLE = 0;
        private static final int STATE_WAITING_LOCK = 1;
        private static final int STATE_WAITING_PRECAPTURE = 2;
        private static final int STATE_WAITING_NON_PRECAPTURE = 3;
        private static final int STATE_PICTURE_TAKEN = 4;
        private int mState = 0;

        FocusingStateMachine(CameraCaptureSession cameraCaptureSession, boolean lockFocus, Handler callbackHandler, FocusListener listener) {
            this.mLockFocus = lockFocus;
            this.mCaptureSession = cameraCaptureSession;
            this.mListener = listener;
            this.mCallbackHandler = callbackHandler != null ? callbackHandler : new Handler();
            this.mFocusingStateMachineThread = new HandlerThread("Camera Focus Background");
            this.mFocusingStateMachineThread.start();
            this.mFocusingStateMachineHandler = new Handler(this.mFocusingStateMachineThread.getLooper());
            try {
                this.mPreviewRequestBuilder = this.mCaptureSession.getDevice().createCaptureRequest(1);
            }
            catch (CameraAccessException cae) {
                this.onError((Exception)((Object)cae));
            }
        }

        void start(Surface previewSurface) {
            if (this.mPreviewRequestBuilder == null) {
                throw new IllegalStateException("There was an error when setting up the FocusManager.FocusingStateMachine - did you ignore an exception from the constructor....?");
            }
            try {
                this.mPreviewRequestBuilder.addTarget(previewSurface);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                this.mCaptureSession.setRepeatingRequest(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)FocusManager.this.mStateMachine, this.mFocusingStateMachineHandler);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)1);
                this.mState = 1;
                this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), (CameraCaptureSession.CaptureCallback)FocusManager.this.mStateMachine, this.mFocusingStateMachineHandler);
            }
            catch (CameraAccessException cae) {
                this.onError((Exception)((Object)cae));
            }
            catch (Exception e) {
                this.onError(e);
            }
        }

        public void close() {
            this.mState = 0;
            if (this.mPreviewRequestBuilder != null) {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_TRIGGER, (Object)2);
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_MODE, (Object)1);
                if (FocusManager.this.mCameraCaptureSession != null) {
                    try {
                        FocusManager.this.mCameraCaptureSession.capture(this.mPreviewRequestBuilder.build(), null, null);
                        FocusManager.this.mCameraCaptureSession.stopRepeating();
                        Log.i((String)FocusManager.TAG, (String)"Stopped repeating");
                    }
                    catch (CameraAccessException cae) {
                        this.onError((Exception)((Object)cae));
                    }
                    FocusManager.this.mCameraCaptureSession = null;
                }
                this.mPreviewRequestBuilder = null;
            }
        }

        public void onCaptureProgressed(CameraCaptureSession session, CaptureRequest request, CaptureResult partialResult) {
            this.process(partialResult);
        }

        public void onCaptureCompleted(CameraCaptureSession session, CaptureRequest request, TotalCaptureResult result) {
            this.process((CaptureResult)result);
        }

        public void onCaptureSequenceCompleted(CameraCaptureSession session, int sequenceId, long frameNumber) {
            super.onCaptureSequenceCompleted(session, sequenceId, frameNumber);
            if (this.mState == 0 && this.mFocusingStateMachineThread != null) {
                Log.i((String)FocusManager.TAG, (String)"Killed focusing thread");
                try {
                    this.mFocusingStateMachineHandler.removeCallbacksAndMessages(null);
                    this.mFocusingStateMachineThread.quitSafely();
                    this.mFocusingStateMachineThread.join();
                    this.mFocusingStateMachineThread = null;
                    this.mFocusingStateMachineHandler = null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private void process(CaptureResult result) {
            Log.i((String)FocusManager.TAG, (String)("FocusingStateMachine.process() mState = " + this.mState));
            switch (this.mState) {
                case 0: {
                    break;
                }
                case 1: {
                    Integer autoFocusState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
                    if (autoFocusState == null) {
                        this.onFocusLocked();
                        this.mState = 4;
                        break;
                    }
                    if (4 != autoFocusState && 5 != autoFocusState) break;
                    autoFocusState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (autoFocusState == null || autoFocusState == 2) {
                        this.onFocusLocked();
                        this.mState = 4;
                        break;
                    }
                    this.runPrecaptureSequence();
                    break;
                }
                case 2: {
                    Integer autoExposureState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (autoExposureState != null && autoExposureState != 5 && autoExposureState != 4) break;
                    this.mState = 3;
                    break;
                }
                case 3: {
                    Integer autoExposureState = (Integer)result.get(CaptureResult.CONTROL_AE_STATE);
                    if (autoExposureState != null && autoExposureState == 5) break;
                    this.onFocusLocked();
                    this.mState = 4;
                    break;
                }
            }
        }

        private void runPrecaptureSequence() {
            try {
                this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, (Object)1);
                this.mState = 2;
                this.mCaptureSession.capture(this.mPreviewRequestBuilder.build(), null, null);
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
            }
        }

        private void onFocusLocked() {
            Log.i((String)FocusManager.TAG, (String)"focus lock");
            try {
                if (this.mLockFocus) {
                    this.mCaptureSession.stopRepeating();
                }
                if (this.mListener != null) {
                    this.mCallbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            FocusingStateMachine.this.mListener.focusLocked();
                        }
                    });
                }
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
                throw new UnsupportedOperationException("Camera access required 3");
            }
        }

        private void onError(final Exception error) {
            Log.e((String)FocusManager.TAG, (String)"focusing error");
            try {
                this.mCaptureSession.stopRepeating();
                if (this.mListener != null) {
                    this.mCallbackHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            FocusingStateMachine.this.mListener.error(error);
                        }
                    });
                }
            }
            catch (CameraAccessException e) {
                e.printStackTrace();
                throw new UnsupportedOperationException("Camera access required 4");
            }
        }
    }

    public static interface FocusListener {
        public void focusLocked();

        public void error(Exception var1);
    }

    static class CompareSizesByArea
    implements Comparator<Size> {
        CompareSizesByArea() {
        }

        @Override
        public int compare(Size lhs, Size rhs) {
            return Long.signum((long)lhs.getWidth() * (long)lhs.getHeight() - (long)rhs.getWidth() * (long)rhs.getHeight());
        }
    }
}

