/*
 * Decompiled with CFR 0.152.
 */
package dk.schaumburgit.stillsequencecamera.camera2;

import android.app.Activity;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.TextureView;
import dk.schaumburgit.stillsequencecamera.IStillSequenceCamera;
import dk.schaumburgit.stillsequencecamera.camera2.CaptureManager;
import dk.schaumburgit.stillsequencecamera.camera2.FocusManager;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jdeferred.Deferred;
import org.jdeferred.DoneCallback;
import org.jdeferred.Promise;
import org.jdeferred.impl.DeferredObject;

public class StillSequenceCamera2
implements IStillSequenceCamera {
    private static final String TAG = "StillSequenceCamera2";
    private final Activity mActivity;
    private HandlerThread mFocusThread;
    private Handler mFocusHandler;
    private CameraCaptureSession mCaptureSession;
    private final String mCameraId;
    private CameraDevice mCameraDevice;
    private Semaphore mCameraOpenCloseLock = new Semaphore(1);
    private FocusManager mFocusManager;
    private CaptureManager mImageCapture;
    private static final int CLOSED = 0;
    private static final int INITIALIZED = 1;
    private static final int CAPTURING = 2;
    private static final int STARTING = 3;
    private static final int STOPPING = 4;
    private static final int FOCUSING = 5;
    private static final int FAILED = 6;
    private static final int ERROR = 7;
    private int mState = 0;
    private boolean mLockFocus = true;
    private Promise<Void, String, Void> mStopping = null;

    public StillSequenceCamera2(Activity activity) {
        this(activity, null, 786432);
    }

    public StillSequenceCamera2(Activity activity, int minPixels) {
        this(activity, null, minPixels);
    }

    public StillSequenceCamera2(Activity activity, TextureView textureView, int minPixels) {
        if (activity == null) {
            throw new NullPointerException("StillSequenceCamera2 requires an Activity");
        }
        if (minPixels < 786432) {
            minPixels = 786432;
        }
        this.mActivity = activity;
        this.mFocusManager = new FocusManager(activity, textureView);
        this.mImageCapture = new CaptureManager(activity, minPixels);
        this.mState = 0;
        String selection = null;
        try {
            CameraManager manager = (CameraManager)this.mActivity.getSystemService("camera");
            for (String cameraId : manager.getCameraIdList()) {
                CameraCharacteristics characteristics = manager.getCameraCharacteristics(cameraId);
                Integer facing = (Integer)characteristics.get(CameraCharacteristics.LENS_FACING);
                if (facing != null && facing == 0) continue;
                selection = cameraId;
            }
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"Camera2 API is not supported");
            throw new UnsupportedOperationException("Camera2 API is not supported");
        }
        this.mCameraId = selection;
    }

    @Override
    public Map<Integer, Double> getSupportedImageFormats() {
        return this.mImageCapture.getSupportedImageFormats(this.mCameraId);
    }

    @Override
    public void setup(int imageFormat) throws IllegalStateException {
        if (this.mState != 0) {
            throw new IllegalStateException("StillSequenceCamera2.setup() can only be called in the CLOSED state");
        }
        try {
            this.mImageCapture.setup(this.mCameraId, imageFormat);
            this.mFocusManager.setup(this.mCameraId);
        }
        catch (NullPointerException e) {
            Log.e((String)TAG, (String)"Camera2 API is not supported");
            throw new UnsupportedOperationException("Camera2 API is not supported");
        }
        this.mState = 1;
    }

    @Override
    public void start(final IStillSequenceCamera.OnImageAvailableListener listener, Handler callbackHandler) {
        if (this.mState == 3) {
            return;
        }
        if (callbackHandler == null) {
            callbackHandler = new Handler();
        }
        final Handler _callbackHandler = callbackHandler;
        Promise<Void, String, Void> stoppingPromise = this.getStoppingPromise();
        if (stoppingPromise != null && stoppingPromise.isPending()) {
            stoppingPromise.then((DoneCallback)new DoneCallback<Void>(){

                public void onDone(Void result) {
                    StillSequenceCamera2.this.start(listener, _callbackHandler);
                }
            });
            return;
        }
        if (this.mState != 1) {
            throw new IllegalStateException("StillSequenceCamera2.start() can only be called in the INITIALIZED state (" + this.mState + ")");
        }
        this.mState = 3;
        this.mFocusThread = new HandlerThread("CameraBackground");
        this.mFocusThread.start();
        this.mFocusHandler = new Handler(this.mFocusThread.getLooper());
        CameraManager manager = (CameraManager)this.mActivity.getSystemService("camera");
        try {
            if (!this.mCameraOpenCloseLock.tryAcquire(2500L, TimeUnit.MILLISECONDS)) {
                throw new RuntimeException("Time out waiting to lock camera opening.");
            }
            manager.openCamera(this.mCameraId, new CameraDevice.StateCallback(){

                public void onOpened(CameraDevice cameraDevice) {
                    Log.d((String)StillSequenceCamera2.TAG, (String)"CameraDevice opened");
                    StillSequenceCamera2.this.mCameraOpenCloseLock.release();
                    StillSequenceCamera2.this.mCameraDevice = cameraDevice;
                    try {
                        StillSequenceCamera2.this.mCameraDevice.createCaptureSession(Arrays.asList(StillSequenceCamera2.this.mFocusManager.getSurface(), StillSequenceCamera2.this.mImageCapture.getSurface()), new CameraCaptureSession.StateCallback(){

                            public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                                if (null == StillSequenceCamera2.this.mCameraDevice) {
                                    return;
                                }
                                Log.d((String)StillSequenceCamera2.TAG, (String)"CameraDevice configured");
                                StillSequenceCamera2.this.mCaptureSession = cameraCaptureSession;
                                StillSequenceCamera2.this.mState = 5;
                                StillSequenceCamera2.this.mFocusManager.start(StillSequenceCamera2.this.mCaptureSession, StillSequenceCamera2.this.mLockFocus, StillSequenceCamera2.this.mFocusHandler, new FocusManager.FocusListener(){

                                    @Override
                                    public void focusLocked() {
                                        StillSequenceCamera2.this.mState = 2;
                                        if (StillSequenceCamera2.this.mLockFocus) {
                                            StillSequenceCamera2.this.mFocusManager.stop();
                                        }
                                        StillSequenceCamera2.this.mImageCapture.start(StillSequenceCamera2.this.mCaptureSession, _callbackHandler, listener);
                                    }

                                    @Override
                                    public void error(final Exception error) {
                                        StillSequenceCamera2.this.mState = 7;
                                        StillSequenceCamera2.this.mFocusManager.stop();
                                        if (listener != null) {
                                            _callbackHandler.post(new Runnable(){

                                                @Override
                                                public void run() {
                                                    listener.onError(error);
                                                }
                                            });
                                        }
                                    }
                                });
                            }

                            public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                                StillSequenceCamera2.this.mState = 7;
                                Log.e((String)StillSequenceCamera2.TAG, (String)"Failed");
                                if (listener != null) {
                                    StillSequenceCamera2.this.mFocusHandler.post(new Runnable(){

                                        @Override
                                        public void run() {
                                            listener.onError(null);
                                        }
                                    });
                                }
                            }
                        }, null);
                    }
                    catch (CameraAccessException e) {
                        StillSequenceCamera2.this.mState = 6;
                        e.printStackTrace();
                        throw new UnsupportedOperationException("Camera access required 2: " + e.getMessage());
                    }
                }

                public void onDisconnected(CameraDevice cameraDevice) {
                    StillSequenceCamera2.this.mCameraOpenCloseLock.release();
                    cameraDevice.close();
                    StillSequenceCamera2.this.mCameraDevice = null;
                }

                public void onError(CameraDevice cameraDevice, int error) {
                    Log.e((String)StillSequenceCamera2.TAG, (String)("CameraDevice.StateCallback.onError(" + error + ")"));
                    StillSequenceCamera2.this.mCameraOpenCloseLock.release();
                    cameraDevice.close();
                    StillSequenceCamera2.this.mCameraDevice = null;
                    if (null != StillSequenceCamera2.this.mActivity) {
                        StillSequenceCamera2.this.mActivity.finish();
                    }
                }
            }, this.mFocusHandler);
        }
        catch (CameraAccessException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("CAMERA access required");
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new UnsupportedOperationException("CAMERA permission required");
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while trying to lock camera opening.", e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private synchronized Promise<Void, String, Void> getStoppingPromise() {
        return this.mStopping;
    }

    private synchronized void setStoppingPromise(Promise<Void, String, Void> promise) {
        this.mStopping = promise;
    }

    @Override
    public void stop() {
        if (this.mState == 0) {
            return;
        }
        if (this.mState != 2) {
            throw new IllegalStateException("StillSequenceCamera2.stop() can only be called in the STARTED state");
        }
        DeferredObject deferred = new DeferredObject();
        this.setStoppingPromise((Promise<Void, String, Void>)deferred.promise());
        this.mState = 4;
        new Thread(new Runnable((Deferred)deferred){
            final /* synthetic */ Deferred val$deferred;
            {
                this.val$deferred = deferred;
            }

            @Override
            public void run() {
                try {
                    StillSequenceCamera2.this.mFocusManager.stop();
                    StillSequenceCamera2.this.mImageCapture.stop();
                    StillSequenceCamera2.this.mCameraOpenCloseLock.acquire();
                    if (StillSequenceCamera2.this.mCaptureSession != null) {
                        StillSequenceCamera2.this.mCaptureSession.close();
                        StillSequenceCamera2.this.mCaptureSession = null;
                    }
                    if (null != StillSequenceCamera2.this.mCameraDevice) {
                        StillSequenceCamera2.this.mCameraDevice.close();
                        StillSequenceCamera2.this.mCameraDevice = null;
                    }
                }
                catch (InterruptedException e) {
                    StillSequenceCamera2.this.setStoppingPromise((Promise<Void, String, Void>)null);
                    this.val$deferred.reject((Object)("Interrupted while trying to lock camera for closing: " + e.getMessage()));
                }
                finally {
                    StillSequenceCamera2.this.mCameraOpenCloseLock.release();
                }
                if (StillSequenceCamera2.this.mFocusThread != null) {
                    try {
                        StillSequenceCamera2.this.mFocusThread.quitSafely();
                        StillSequenceCamera2.this.mFocusThread.join();
                        StillSequenceCamera2.this.mFocusThread = null;
                        StillSequenceCamera2.this.mFocusHandler = null;
                    }
                    catch (Exception e) {
                        StillSequenceCamera2.this.setStoppingPromise((Promise<Void, String, Void>)null);
                        this.val$deferred.reject((Object)("Error stopping the focusing process: " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
                StillSequenceCamera2.this.mState = 1;
                StillSequenceCamera2.this.setStoppingPromise((Promise<Void, String, Void>)null);
                this.val$deferred.resolve(null);
            }
        }).start();
    }

    @Override
    public void close() {
        if (this.mState == 0) {
            return;
        }
        if (this.mState == 2) {
            this.stop();
        }
        if (this.mState != 1) {
            throw new IllegalStateException("StillSequenceCamera2.close() can only be called in the INITIALIZED state");
        }
        this.mFocusManager.close();
        this.mImageCapture.close();
        this.mState = 0;
    }

    @Override
    public boolean isLockFocus() {
        return this.mLockFocus;
    }

    @Override
    public void setLockFocus(boolean lockFocus) {
        this.mLockFocus = lockFocus;
    }
}

